goog.provide('FlappSWFTag');
goog.require('FlappSWFTagShowFrame');
goog.require('FlappSWFTagDefineShape');
goog.require('FlappSWFTagDefineBitsJPEG');
goog.require('FlappSWFTagDefineSprite');
goog.require('FlappSWFTagJPEGTables');
goog.require('FlappSWFTagSetBackgroundColor');
goog.require('FlappSWFTagDoAction');
goog.require('FlappSWFTagPlaceObject');
goog.require('FlappSWFTagRemoveObject');

goog.scope(function() {

/**
 * @constructor
 */
FlappSWFTag = function() {
     ;
};

// tag factory
FlappSWFTag.load = function(code, length, ibit) {
//        console.log("FlappSWFTag.load(code:"+code+", length:"+length+", ibit)");
    var tag = null;
    switch (code) {
    case 1: // ShowFrame
        tag = new FlappSWFTagShowFrame(code, length, ibit);
        break;
    case 2: // DefineShape
    case 22: // DefineShape2
    case 32: // DefineShape3
        tag = new FlappSWFTagDefineShape(code, length, ibit);
        break;
    case 4: // PlaceObject
    case 26: // PlaceObject2
        tag = new FlappSWFTagPlaceObject(code, length, ibit);
        break;
    case 5: // RemoveObject
    case 28: // RemoveObject
        tag = new FlappSWFTagRemoveObject(code, length, ibit);
        break;
    case 6: // DefineBits(JPEG)
    case 21: // DefineBitsJPEG2
    case 35: // DefineBitsJPEG3
        tag = new FlappSWFTagDefineBitsJPEG(code, length, ibit);
        break;
    case 8: // JPEGTables
        tag = new FlappSWFTagJPEGTables(code, length, ibit);
        break;
    case 9: // SetBackgroundColor
        tag = new FlappSWFTagSetBackgroundColor(code, length, ibit);
        break;
    case 12: // DoAction
        tag = new FlappSWFTagDoAction(code, length, ibit);
        break;
    case 39: // DefineSprite
        tag = new FlappSWFTagDefineSprite(code, length, ibit);
        break;
    }
//        console.debug(tag);
    return tag;
};

});
