goog.provide('FlappSWFFillStyles');
goog.require('FlappSWFMatrix');
goog.require('FlappSWFGradient');
goog.require('FlappSWFRGBA');

goog.scope(function() {

/**
 * @constructor
 */
FlappSWFFillStyles = function(ibit) {
    ;
};

FlappSWFFillStyles.load = function(code, ibit) {
    ibit.a();
    var count = ibit.ui8();
    if ((code > 2) && (count === 0xff)) {
        count = ibit.ui16();
    }
    var fillStyles = new Array(count);
    var hasAlpha = (code < 32)?false:true;
    for (var i = 0 ; i < count ;  i++) {
        fillStyles[i] = FlappSWFFillStyles.loadStyle(ibit, hasAlpha);
    }
    return fillStyles;
};

FlappSWFFillStyles.loadStyle = function(ibit, hasAlpha) {
    ibit.a();
    var type = ibit.ui8();
    var style = {type: type};
    switch (type) {
    case 0x00: // solid fill
        style.color = FlappSWFRGBA.load(ibit, hasAlpha);
        break;
    case 0x10: // linear gradient fill
    case 0x12: // radial gradient fill
        style.matrix = FlappSWFMatrix.load(ibit);
        style.gradient = FlappSWFGradient.load(ibit, hasAlpha);
        break;
    case 0x13: // focal radial gradient fill
        style.matrix = FlappSWFMatrix.load(ibit);
        style.gradient = FlappSWFGradient.load(ibit, hasAlpha);
        break;
    case 0x40: // repeating bitmap fill
    case 0x41: // clipped bitmap fill
    case 0x42: // non-smoothed repeating bitmap
    case 0x43: // non-smoothed clipped bitmap
        style.bitmapId = ibit.ui16();
        style.matrix = FlappSWFMatrix.load(ibit);
        break;
    }
    return style;
}

});
