goog.provide('FlappSWFCXForm');

goog.scope(function() {

/**
 * @constructor
 */
FlappSWFCXForm = function(ibit) {
    ;
};

FlappSWFCXForm.load = function(ibit, hasAlpha) {
    ibit.a();
    var hasAddTerms = ibit.b();
    var hasMultiTerms = ibit.b();
    var nBits = ibit.ub(4);
    if (hasMultiTerms) {
        var redMultiTerm   = ibit.sb(nBits);
        var greenMultiTerm = ibit.sb(nBits);
        var blueMultiTerm  = ibit.sb(nBits);
        if (hasAlpha) {
            var alphaMultiTerm = ibit.sb(nBits);
        }
    } else {
        var redMultiTerm   = 256;
        var greenMultiTerm = 256;
        var blueMultiTerm  = 256;
        if (hasAlpha) {
            var alphaMultiTerm = 256;
        }
    }
    if (hasAddTerms) {
        var redAddTerm   = ibit.sb(nBits);
        var greenAddTerm = ibit.sb(nBits);
        var blueAddTerm  = ibit.sb(nBits);
        if (hasAlpha) {
            var alphaAddTerm = ibit.sb(nBits);
        }
    } else {
        var redAddTerm   = 0;
        var greenAddTerm = 0;
        var blueAddTerm  = 0;
        if (hasAlpha) {
            var alphaAddTerm = 0;
        }
    }
    return {
        redMultiTerm:redMultiTerm,
        greenMultiTerm:greenMultiTerm,
        blueMultiTerm:blueMultiTerm,
        redAddTerm:redAddTerm,
        greenAddTerm:greenAddTerm,
        blueAddTerm:blueAddTerm
    };
};

});
