goog.provide('FlappCanvas');

goog.scope(function() {

/**
 * @constructor
 */
FlappCanvas = function(canvas) {
    this.canvas = canvas;
    this['ctx'] = this.ctx = canvas.getContext('2d'); // for closure compilre
};

FlappCanvas.prototype = {
    clear: function() {
//        console.debug("FlappCanvas::clear");
        // this.ctx.clearRect(0, 0, this.canvas.width, this.canvas.height);
        this.canvas.width = this.canvas.width;
    },
    setTransform: function(matrix) {
        this.ctx.setTransform(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
    },
    transform: function(matrix) {
        this.ctx.transform(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
    }
}

});
