package net.tk_factory.sample.refrection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;

/**
 * ե쥯ѤץץǤ<br/>
 * <br/>
 * <b>:</b>
 * <ol type="1">
 * <li>饹ΥեɤʬϤޤ</li>
 * <li>饹Υ󥹥ȥ饯ʬϤޤ</li>
 * <li>饹Υ᥽åɤʬϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 */
public class SampleAnalysisClass extends AbstractSample
{
    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleAnalysisClass.class.getName());

    /**
     * SampleAnalysisClass֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleAnalysisClass()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    @SuppressWarnings("unchecked")
    public static void main(String[] args)
    {
        try
        {
            // 饹
            Class cls = Class.forName("java.lang.String");

            // եʬ
            analysisField(cls);

            // 󥹥ȥ饯ʬ
            analysisConstructors(cls);

            // ᥽åʬ
            analysisMethod(cls);
        }
        catch (ClassNotFoundException cnfex)
        {
            LOGGER.error(getStackTrace(cnfex));
        }
    }

    /**
     * 饹ΥեɤʬϤ˽Ϥޤ<br/>
     *
     * @param cls 饹
     */
    @SuppressWarnings("unchecked")
    private static void analysisField(Class cls)
    {
        StringBuffer value;
        Field[] fields = cls.getFields();
        for (int i = 0; i < fields.length; i++)
        {
            Field field = fields[i];
            value = new StringBuffer("");

            // 
            value.append(Modifier.toString(field.getModifiers()));

            // 
            value.append(" ")
                .append(field.getType().getName());

            // ե̾
            value.append(" ")
                .append(field.getName());

            LOGGER.debug(value.toString());
        }
    }

    /**
     * 饹Υ󥹥ȥ饯ʬϤ˽Ϥޤ<br/>
     *
     * @param cls 饹
     */
    @SuppressWarnings("unchecked")
    private static void analysisConstructors(Class cls)
    {
        StringBuffer value;
        Constructor[] constructors = cls.getConstructors();
        for (int i = 0; i < constructors.length; i++)
        {
            Constructor constructor = constructors[i];
            value = new StringBuffer("");

            // 
            value.append(Modifier.toString(constructor.getModifiers()));

            // 󥹥ȥ饯̾
            value.append(" ")
                .append(constructor.getDeclaringClass().getName());

            // η
            Class[] params = constructor.getParameterTypes();
            value.append("(");
            for (int j = 0; j < params.length; j++)
            {
                value.append(params[j].getName());
                if (params.length > 1 && j != params.length - 1)
                {
                    value.append(", ");
                }
            }
            value.append(")");
            LOGGER.debug(value.toString());
        }
    }

    /**
     * 饹Υ᥽åɤʬϤ˽Ϥޤ<br/>
     *
     * @param cls 饹
     */
    @SuppressWarnings("unchecked")
    private static void analysisMethod(Class cls)
    {
        StringBuffer value;
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length;i++)
        {
            Method method = methods[i];
            value = new StringBuffer("");

            // 
            value.append(Modifier.toString(method.getModifiers()));

            // ͤη
            value.append(" ")
                .append(method.getReturnType().getName());

            // ᥽å̾
            value.append(" ")
                .append(method.getName());

            // η
            Class[] params = method.getParameterTypes();
            value.append("(");
            for (int j = 0; j < params.length; j++)
            {
                value.append(params[j].getName());
                if (params.length > 1 && j != params.length - 1)
                {
                    value.append(", ");
                }
            }
            value.append(")");
            LOGGER.debug(value.toString());
        }
    }
}
