package net.tk_factory.sample.jfreechart;

import java.io.FileOutputStream;
import java.io.IOException;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>ҥȥޤ</li>
 * <li>ChartUtilities饹ѤơPNGǲϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 *
 * @see org.jfree.chart.ChartFactory#createHistogram
 * @see org.jfree.chart.StandardChartTheme#createLegacyTheme
 */
public class SampleCreateHistogram extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleCreateHistogram.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleCreateHistogram.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleCreateHistogram֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleCreateHistogram()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            //ҥȥΥǡꤹ
            HistogramDataset dataset = new HistogramDataset();
            double[] values =
            {
                10.19D, 10.18D, 10.18D, 10.12D, 10.19D,
                10.22D, 10.17D, 10.22D, 10.20D, 10.13D,
                10.19D, 10.14D, 10.21D, 10.18D, 10.16D,
                10.24D, 10.12D, 10.17D, 10.22D, 10.22D,
                10.21D, 10.17D, 10.19D, 10.19D, 10.18D,
                10.20D, 10.19D, 10.23D, 10.16D, 10.15D,
                10.19D, 10.16D, 10.17D, 10.23D, 10.19D,
                10.35D, 10.24D, 10.19D, 10.20D, 10.17D,
                10.14D, 10.26D, 10.18D, 10.18D, 10.20D,
                10.29D, 10.20D, 10.16D, 10.16D, 10.16D,
            };
            dataset.addSeries("ߤ", values, 10);

            //ҥȥ
            JFreeChart chart = ChartFactory.createHistogram(
                    //եȥ
                    "ʬ",
                    //ƥ꼴٥
                    "",
                    //ͼ٥
                    "Ŀ",
                    //ǡå
                    dataset,
                    //դν
                    PlotOrientation.VERTICAL,
                    //Ƚɽ̵ͭ
                    true,
                    //ġåפɽ̵ͭ
                    false,
                    //URLưŪ̵ͭ
                    false);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
