package net.tk_factory.sample.apache.poi.sheet;

import java.io.FileOutputStream;
import java.io.IOException;
import net.tk_factory.sample.AbstractSample;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/**
 * Apache POI-HSSFѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>HSSFSheet饹setZoom᥽åɤѤơȤ硦̾ޤ</li>
 * </ol>
 * @author Takafumi Kondo (TK Factory)
 * @see org.apache.poi.hssf.usermodel.HSSFSheet#setZoom(int, int)
 */
public class SampleSetZoom extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleSetZoom.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleSetZoom.class.getName());

    /** ϥե̾ */
    private static final String OUT_FILE_NAME =
        SAMPLE_FILE_DIRECTORY + CLASS_NAME + "Out.xls";

    /**
     * SampleSetZoom֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleSetZoom()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream out = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME);

            //֥å
            HSSFWorkbook workbook = new HSSFWorkbook();
            LOGGER.debug(workbook.toString());

            //Ȥɲä
            HSSFSheet sheet1 = workbook.createSheet();
            LOGGER.debug(sheet1.toString());

            //Ȥ礹(200%)
            sheet1.setZoom(2, 1);

            //Ȥɲä
            HSSFSheet sheet2 = workbook.createSheet();
            LOGGER.debug(sheet2.toString());

            //Ȥ̾(50%)
            sheet2.setZoom(1, 2);

            //ե¸
            out = new FileOutputStream(OUT_FILE_NAME);
            workbook.write(out);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (out != null)
                {
                    out.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
