﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class SerializableCollections

        <Serializable()> _
        Public Class List(Of T As Class)
            Inherits System.Collections.Generic.List(Of T)
            Implements Xml.Serialization.IXmlSerializable

            Private Function XmlSerializer() As Xml.Serialization.XmlSerializer
                Return New Xml.Serialization.XmlSerializer(GetType(T))
            End Function

            Public Function GetSchema() As System.Xml.Schema.XmlSchema Implements System.Xml.Serialization.IXmlSerializable.GetSchema
                Return Nothing
            End Function

            Public Sub ReadXml(ByVal reader As System.Xml.XmlReader) Implements System.Xml.Serialization.IXmlSerializable.ReadXml

                If reader.IsEmptyElement Then
                    reader.Read() ' skip to next node
                    Exit Sub
                End If

                Dim strElementName As String = reader.Name
                Dim objPresetReader As Xml.Serialization.XmlSerializer = XmlSerializer()
                reader.Read() ' enter node
                While True
                    reader.MoveToContent() ' skip white space
                    Select Case reader.NodeType
                        Case Xml.XmlNodeType.EndElement
                            If reader.Name <> strElementName Then
                                MsgBox("SerializableDictionary XML ReadError:Invalid EndElement <" & reader.Name & "/>")
                            End If
                            reader.Read() ' skip to next node
                            Exit While
                        Case Xml.XmlNodeType.Element
                            Dim item As T = TryCast(objPresetReader.Deserialize(reader), T)
                            If Not item Is Nothing Then Me.Add(item)
                        Case Xml.XmlNodeType.CDATA
                            reader.Read() ' skip
                    End Select
                End While

            End Sub

            Public Sub WriteXml(ByVal writer As System.Xml.XmlWriter) Implements System.Xml.Serialization.IXmlSerializable.WriteXml
                If 0 < Count Then
                    Dim xsr As Xml.Serialization.XmlSerializer = XmlSerializer()
                    For idx As Integer = 0 To Count - 1
                        xsr.Serialize(writer, Item(idx))
                    Next
                End If
            End Sub
        End Class

    End Class
End Class
