﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class FileSystem

        Public MustInherit Class PathBase
            Inherits Logic.SerializableCollections.ProtectedSerializable(Of String)
            Implements IComparable
            Implements IComparable(Of PathBase)
            Implements IEquatable(Of PathBase)
            Implements IEquatable(Of String)

            ' public properties ////////////////////////////////////////////////////////////////////////////////////////////////////////////

            Public Shared Operator =(ByVal x As PathBase, ByVal y As PathBase) As Boolean
                If x Is y Then Return True
                If x IsNot Nothing Then Return x.Equals(y)
                Return y.Equals(x)
            End Operator

            Public Shared Operator <>(ByVal x As PathBase, ByVal y As PathBase) As Boolean
                Return Not (x = y)
            End Operator

            Public Shared Function Compare(ByVal x As String, ByVal y As String) As Integer
                Compare = String.Compare(x, y, Comparison)
                If Compare <> 0 And String.IsNullOrWhiteSpace(x) = True And String.IsNullOrWhiteSpace(y) = True Then Compare = 0
            End Function

            Public Function CompareTo(ByVal other As String) As Integer
                Return Compare(Payload, other)
            End Function

            Public Function CompareTo(ByVal obj As Object) As Integer Implements System.IComparable.CompareTo
                Dim other As String = Nothing
                If obj IsNot Nothing Then other = obj.ToString
                Return Compare(Payload, other)
            End Function

            Public Function CompareTo(ByVal other As PathBase) As Integer Implements IComparable(Of PathBase).CompareTo
                Dim other_string As String = Nothing
                If other IsNot Nothing Then other_string = other.Payload
                Return Compare(Payload, other.Payload)
            End Function

            Public Const Comparison As StringComparison = StringComparison.OrdinalIgnoreCase

            Public Overloads Function Equals(ByVal other As PathBase) As Boolean Implements System.IEquatable(Of PathBase).Equals
                If other Is Nothing Then Return False
                Return FileSystem.PathBase.Equals(Payload, other.Payload)
            End Function

            Public Overloads Function Equals(ByVal other As String) As Boolean Implements System.IEquatable(Of String).Equals
                Return FileSystem.PathBase.Equals(Payload, other)
            End Function

            Public Overloads Shared Function Equals(ByVal x As String, ByVal y As String) As Boolean
                Equals = String.Equals(x, y, Comparison) OrElse (String.IsNullOrWhiteSpace(x) = True And String.IsNullOrWhiteSpace(y) = True)
            End Function

            Public Overloads Shared Function Equals(ByVal x As PathBase, ByVal y As PathBase) As Boolean
                Return x = y
            End Function

            Public Overrides Function GetHashCode() As Integer
                If String.IsNullOrWhiteSpace(Payload) Then Return String.Empty.GetHashCode
                Return Payload.ToLower.GetHashCode
            End Function

            Public MustOverride ReadOnly Property GetValidater As FileSystem.PathStringValidater

            Public Function IsNullOrWhiteSpace() As Boolean
                Return String.IsNullOrWhiteSpace(Payload)
            End Function

            Public Overrides Function ToString() As String
                Return Payload
            End Function

        End Class
    End Class
End Class


