﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class FileSystem

        Public Class Extention
            Inherits PathBase(Of Extention.StringValidater)
            Public Shadows Class StringValidater
                Inherits FileSystem.PathStringValidater
                ' construct
                Public Sub New()
                    Dim codes As New System.Collections.Generic.List(Of Char)(Path.Validater.InvalidChars)
                    ' append some invalid code
                    For Each code As Char In {" "c, vbTab, "."c, "*"c, ","c, "&"c, "%"c, "|"c, "+"c, "-"c}
                        If codes.Contains(code) = False Then codes.Add(code)
                    Next
                    m_InvalidChars = codes.ToArray
                End Sub
                ' public properties
                Private ReadOnly m_InvalidChars As Char()
                Public Overrides ReadOnly Property InvalidChars As Char()
                    Get
                        Return m_InvalidChars
                    End Get
                End Property
            End Class

            Public Class Collection
                Inherits PathBase(Of Extention.StringValidater).CollectionBase(Of Extention)
                Public Sub New()
                    MyBase.New()
                End Sub
                Public Sub New(ByVal s As String)
                    MyBase.New(s)
                End Sub
                Public Sub New(ByVal s As System.Collections.Generic.IEnumerable(Of String))
                    MyBase.New(s)
                End Sub
                Public Shared Widening Operator CType(ByVal s As String) As Collection
                    Return New Collection(s)
                End Operator
            End Class

            Public Sub New()
                MyBase.New()
            End Sub

            Public Sub New(ByVal s As String)
                MyBase.New(s)
            End Sub

            Public Shared Widening Operator CType(ByVal s As String) As Extention
                Return New Extention(s)
            End Operator

        End Class

    End Class
End Class