﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class DataGridViewUtility

        Public Class ColumnDisplayInf ' /////////////////////////////////////////////////////////////////////////////////////////////////////////

            Public Name As String
            Public DisplayIndex As Integer
            Public Visible As Boolean
            Public Width As Integer

            Public Sub Apply(ByVal Dest As Windows.Forms.DataGridView)
                Dim col As DataGridViewColumn = Dest.Columns(Name)
                If col Is Nothing Then Return
                Try
                    col.Visible = Visible
                    If 0 < Width Then col.Width = Width
                    If 0 <= DisplayIndex Then col.DisplayIndex = DisplayIndex
                Catch ex As Exception
#If DEBUG Then
                    Throw
#End If
                End Try
            End Sub

            Public Sub Present(ByVal Src As Windows.Forms.DataGridViewColumn)
                If Src Is Nothing Then Return
                Name = Src.Name
                Visible = Src.Visible
                Width = IIf(Src.AutoSizeMode = Windows.Forms.DataGridViewAutoSizeColumnMode.Fill, 0, Src.Width)
                DisplayIndex = IIf(Src.Frozen = True, -1, Src.DisplayIndex)
            End Sub

            Public Class Collection
                Inherits Logic.SerializableCollections.ProtectedSerializable(Of ColumnDisplayInf())
                Public Sub Apply(ByVal Dest As Windows.Forms.DataGridView)
                    If Payload Is Nothing Then Return
                    For Each col As ColumnDisplayInf In Payload
                        If Not col Is Nothing Then col.Apply(Dest)
                    Next
                End Sub
                Public Sub Present(ByVal Src As Windows.Forms.DataGridView)
                    If Src.ColumnCount <= 0 Then
                        Erase Payload
                        Payload = Nothing
                        Exit Sub
                    End If
                    If Payload Is Nothing OrElse Payload.Length <> Src.ColumnCount Then ReDim Payload(Src.ColumnCount - 1)
                    For idx As Integer = 0 To Src.ColumnCount - 1
                        If Payload(idx) Is Nothing Then Payload(idx) = New ColumnDisplayInf
                        Payload(idx).Present(Src.Columns(idx))
                    Next
                End Sub
            End Class ' ColumnDisplayInf.Collection

        End Class ' ColumnDisplayInf

    End Class
End Class
