﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Imports System.Collections

Partial Public Class Logic
    Partial Class Collections

        Public Class ReadOnlySortedDictionary(Of TKey, TValue)

            Public Sub New(ByVal src As Generic.IDictionary(Of TKey, TValue), Optional ByVal cmp As Generic.IComparer(Of TKey) = Nothing)
                Payload = Nothing
                If src IsNot Nothing AndAlso 0 < src.Count Then
                    Payload = New Generic.SortedDictionary(Of TKey, TValue)(src, cmp)
                End If
            End Sub

            Public Sub New(ByVal src As Generic.IEnumerable(Of IKeyValuePair(Of TKey, TValue)), Optional ByVal cmp As Generic.IComparer(Of TKey) = Nothing)
                Payload = Nothing
                If src IsNot Nothing Then
                    Payload = New Generic.SortedDictionary(Of TKey, TValue)(cmp)
                    For Each Item As IKeyValuePair(Of TKey, TValue) In src
                        If Payload.ContainsKey(Item.Key) = False Then Payload.Add(Item.Key, Item.Value)
                    Next
                    If Payload.Count <= 0 Then Payload = Nothing
                End If
            End Sub

            Public Shared Widening Operator CType(ByVal val As Generic.List(Of IKeyValuePair(Of TKey, TValue))) As ReadOnlySortedDictionary(Of TKey, TValue)
                Return New ReadOnlySortedDictionary(Of TKey, TValue)(val)
            End Operator

            Public Shared Widening Operator CType(ByVal val() As IKeyValuePair(Of TKey, TValue)) As ReadOnlySortedDictionary(Of TKey, TValue)
                Return New ReadOnlySortedDictionary(Of TKey, TValue)(val)
            End Operator

            Default Public ReadOnly Property Item(ByVal key As TKey) As TValue
                Get
                    If Payload Is Nothing Then Throw New ArgumentNullException
                    Return Payload.Item(key)
                End Get
            End Property

            Public Function ContainsKey(ByVal key As TKey) As Boolean
                If Payload Is Nothing Then Return False
                Return Payload.ContainsKey(key)
            End Function

            Public ReadOnly Property Keys As Generic.SortedDictionary(Of TKey, TValue).KeyCollection
                Get
                    If Payload Is Nothing Then Throw New ArgumentNullException
                    Return Payload.Keys
                End Get
            End Property

            Public ReadOnly Property Values As Generic.SortedDictionary(Of TKey, TValue).ValueCollection
                Get
                    If Payload Is Nothing Then Throw New ArgumentNullException
                    Return Payload.Values
                End Get
            End Property

            Private Payload As Generic.SortedDictionary(Of TKey, TValue)
        End Class

    End Class
End Class
