﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Imports System.Windows.Forms

Public Class ExtConfigDialog

    Public CompressSetting As AppBase.ArchiveOptionConfigCollection

    Private Sub dlgExtConfig_Shown(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Shown

        If CompressSetting Is Nothing Then CompressSetting = New AppBase.ArchiveOptionConfigCollection

        rdTypeZip.Tag = AppBase.ENUM_ARCHIVETYPE.ZIP
        rdTypeRar.Tag = AppBase.ENUM_ARCHIVETYPE.RAR

        Select Case CompressSetting.SelectedType
            Case AppBase.ENUM_ARCHIVETYPE.RAR
                rdTypeRar.Checked = True
            Case Else
                rdTypeZip.Checked = True
        End Select

        For Each val As AppBase.Archive.ZipCompressionLv In [Enum].GetValues(GetType(AppBase.Archive.ZipCompressionLv))
            Dim strAdd As String = AppBase.Archive.ZipOptionConfig.CompressionLevelText(val)
            If Not Zip_cmbLv.Items.Contains(strAdd) Then
                Dim idx As Integer = Zip_cmbLv.Items.Add(strAdd)
                If val = CompressSetting.Zip.nLv Then Zip_cmbLv.SelectedIndex = idx
            End If
        Next

        Zip_txtIgnoreExt.Text = CompressSetting.Zip.IgnoreExt
        Zip_txtStoreExt.Text = CompressSetting.Zip.StoreExt

        For Each val As AppBase.Archive.RarCompressionLv In [Enum].GetValues(GetType(AppBase.Archive.RarCompressionLv))
            Dim strAdd As String = AppBase.Archive.RarOptionConfig.CompressionLevelText(val)
            If Not Rar_cmbLv.Items.Contains(strAdd) Then
                Dim idx As Integer = Rar_cmbLv.Items.Add(strAdd)
                If val = CompressSetting.Rar.nLv Then Rar_cmbLv.SelectedIndex = idx
            End If
        Next

        Rar_numThread.Value = CompressSetting.Rar.nThread
        Rar_numRR.Value = CompressSetting.Rar.nRecoveryRecord
        Rar_txtIgnoreExt.Text = CompressSetting.Rar.IgnoreExt
        Rar_txtStoreExt.Text = CompressSetting.Rar.StoreExt

    End Sub

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click
        Me.DialogResult = System.Windows.Forms.DialogResult.OK
        Me.Close()
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click
        Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.Close()
    End Sub

    Private Sub rdType_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles rdTypeZip.CheckedChanged,
                                                                                                          rdTypeRar.CheckedChanged
        If sender.checked = True AndAlso TypeOf sender.Tag Is AppBase.ENUM_ARCHIVETYPE Then CompressSetting.SelectedType = sender.Tag
    End Sub

    Private Sub Zip_cmbLv_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Zip_cmbLv.SelectedIndexChanged
        If CompressSetting Is Nothing OrElse CompressSetting.Zip Is Nothing Then Return
        CompressSetting.Zip.nLv = AppBase.Archive.ZipOptionConfig.GetCompressionLevel(Zip_cmbLv.SelectedItem)
    End Sub

    Private Sub Rar_cmbLv_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Rar_cmbLv.SelectedIndexChanged
        If CompressSetting Is Nothing OrElse CompressSetting.Rar Is Nothing Then Return
        CompressSetting.Rar.nLv = AppBase.Archive.RarOptionConfig.GetCompressionLevel(Rar_cmbLv.SelectedItem)
    End Sub

    Private Sub Zip_txtIgnoreExt_LostFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles Zip_txtIgnoreExt.LostFocus
        CompressSetting.Zip.IgnoreExt = Zip_txtIgnoreExt.Text
        Zip_txtIgnoreExt.Text = CompressSetting.Zip.IgnoreExt
    End Sub

    Private Sub Zip_txtStoreExt_LostFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles Zip_txtStoreExt.LostFocus
        CompressSetting.Zip.StoreExt = Zip_txtStoreExt.Text
        Zip_txtStoreExt.Text = CompressSetting.Zip.StoreExt
    End Sub

    Private Sub Rar_txtIgnoreExt_LostFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles Rar_txtIgnoreExt.LostFocus
        CompressSetting.Rar.IgnoreExt = Rar_txtIgnoreExt.Text
        Rar_txtIgnoreExt.Text = CompressSetting.Rar.IgnoreExt
    End Sub

    Private Sub Rar_txtStoreExt_LostFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles Rar_txtStoreExt.LostFocus
        CompressSetting.Rar.StoreExt = Rar_txtStoreExt.Text
        Rar_txtStoreExt.Text = CompressSetting.Rar.StoreExt
    End Sub

    Private Sub Rar_numThread_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Rar_numThread.ValueChanged
        If Not CompressSetting Is Nothing AndAlso Not CompressSetting.Rar Is Nothing Then CompressSetting.Rar.nThread = Rar_numThread.Value
    End Sub

    Private Sub Rar_numRR_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Rar_numRR.ValueChanged
        If Not CompressSetting Is Nothing AndAlso Not CompressSetting.Rar Is Nothing Then CompressSetting.Rar.nRecoveryRecord = Rar_numRR.Value
    End Sub

End Class
