﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase

    Public Class PipeStarter

        Public Class SharingMemoryMappedFile
            Public Const MapName As String = "PipeStarter_SharingMemoryMappedFileMapName"
            Public Const ReadCompleteFlagName As String = "PipeStarter_SharingMemoryMappedFileReadCompleteFlagName"
            Public Const ReadCompleteCatchFlagName As String = "PipeStarter_SharingMemoryMappedFileReadCompleteCatchFlagName"
            Public Const CommandListMapName As String = "PipeStarter_SharingMemoryMappedFile_CommandListModeMapName"
            Public Const CommandListConsoleBufferMapName As String = "PipeStarter_SharingMemoryMappedFile_CommandListConsoleBuffer_MapName"
            Public Const CommandListConsoleBufferWriteCompleteFlagName As String = "PipeStarter_SharingMemoryMappedFile_CommandListConsoleBuffer_WriteCompleteFlagName"
            Public Const CommandListConsoleBufferWriteCompleteCatchFlagName As String = "PipeStarter_SharingMemoryMappedFile_CommandListConsoleBuffer_WriteCompleteCatchFlagName"
        End Class

        Public Enum Mode As Integer
            UnicodeTextList
            SizedBinary
            ExecCommandList
            ScanCommandList
        End Enum

        Public Class ModeArgumentParamItem
            Inherits Logic.Collections.KeyValuePair(Of Mode, Logic.CommandlineParser.Arguments.NamedParameterInfo)
            Public Sub New(ByVal key As Mode, ByVal value As Logic.CommandlineParser.Arguments.NamedParameterInfo)
                MyBase.New(key, value)
            End Sub
        End Class

        Public Shared ReadOnly ModeArgumentParams As Logic.Collections.ReadOnlySortedDictionary(Of Mode, Logic.CommandlineParser.Arguments.NamedParameterInfo) = {
            New ModeArgumentParamItem(Mode.UnicodeTextList, New Logic.CommandlineParser.Arguments.NamedParameterInfo("u"c, 0)),
            New ModeArgumentParamItem(Mode.SizedBinary, New Logic.CommandlineParser.Arguments.NamedParameterInfo("b"c, 0)),
            New ModeArgumentParamItem(Mode.ExecCommandList, New Logic.CommandlineParser.Arguments.NamedParameterInfo("e"c, 0)),
            New ModeArgumentParamItem(Mode.ScanCommandList, New Logic.CommandlineParser.Arguments.NamedParameterInfo("c"c, 0))
        }
        Public Shared ReadOnly ModeArgumentParameterSet As New Logic.CommandlineParser.Arguments.SplitInfo(ModeArgumentParams.Values)

    End Class

End Class
