﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase

    Public Class ImagingOptionConfig

        ' public declaration //////////////////////////////////////////////////////////////////////
        Public Const PermitPercentMax As Integer = 200
        Public Const PermitPercentMin As Integer = 3

        ' construct ///////////////////////////////////////////////////////////////////////////////
        Public Sub New()
            SamplingCount = 4
            m_PermitPercent = 75
            IsPermitWideOnNarrow = True
            IsDisplayProgress = True
        End Sub

        ' public property /////////////////////////////////////////////////////////////////////////
        Public SamplingCount As Integer
        Private m_PermitPercent As Integer
        Public Property PermitPercent As Integer
            Get
                Return m_PermitPercent
            End Get
            Set(ByVal value As Integer)
                m_PermitPercent = Math.Max(Math.Min(value, PermitPercentMax), PermitPercentMin)
            End Set
        End Property
        Public IsPermitWideOnNarrow As Boolean
        Public IsDisplayProgress As Boolean

    End Class

End Class
