﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase

    Public Class EchoingObject

        Public ReadOnly ArchiveItemCoverLoad As New ArchiveItemImageLoadArgs.Echoes
        Public ReadOnly ArchiveItemEntrySelected As New ArchiveItemEntrySelectedArgs.Echoes
        Public ReadOnly ArchiveItemRemoved As New ArchiveItemRemovedArgs.Echoes
        Public ReadOnly ArchiveItemScan As New ArchiveItemScanArgs.Echoes
        Public ReadOnly ArchiveItemSelected As New ArchiveItemSelectedArgs.Echoes
        Public ReadOnly Log As New AppendLogArgs.Echoes
        Public ReadOnly Progress As New ProgressArgs.Echoes

        Public Sub TaskCompletedEcho()
            Log.Echo("Completed", AppendLogArgs.LogType.ProgressOutline)
            Log.Echo(String.Empty, AppendLogArgs.LogType.Status)
            Progress.Echo(0)
        End Sub

        Public Sub TaskExitedEcho(Optional ByVal LogExitReason As String = Nothing)
            If String.IsNullOrWhiteSpace(LogExitReason) = False Then Log.Echo(LogExitReason, AppendLogArgs.LogType.Log)
            Log.Echo("Task Exited", AppendLogArgs.LogType.ProgressOutline)
        End Sub

        Public Sub TaskStartEcho(ByVal TaskTitle As String)
            Log.Echo(TaskTitle, AppendLogArgs.LogType.StatusDescription)
            Log.Echo(String.Empty, AppendLogArgs.LogType.ProgressOutline)
            Log.Echo(String.Empty, AppendLogArgs.LogType.Status)
            Progress.Echo(0)
        End Sub

    End Class

End Class

