﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase
    Partial Public Class Archive

        <Serializable()> _
        Public Class RarOptionConfig
            Inherits ArchiveOptionConfig

            Public Const EXT As String = "rar"
            Public Const RECOVERYRECORD_MAX As Integer = 10
            Public Const RECOVERYRECORD_MIN As Integer = 0
            Public Const RECOVERYRECORD_DEF As Integer = 3
            Public Const THREAD_MAX As Integer = 4
            Public Const THREAD_MIN As Integer = 1
            Public Const THREAD_DEF As Integer = 2

            Public Shared ReadOnly CompressionLevelText As New Collections.Generic.Dictionary(Of RarCompressionLv, String) From {
                {RarCompressionLv.None, "無圧縮"},
                {RarCompressionLv.BestSpeed, "最高速度"},
                {RarCompressionLv.Speed, "速度重視"},
                {RarCompressionLv.Normal, "標準"},
                {RarCompressionLv.Compress, "圧縮重視"},
                {RarCompressionLv.BestCompress, "最高圧縮"}
            }
            Public Shared Function GetCompressionLevel(ByRef str As String) As RarCompressionLv
                For Each Key As RarCompressionLv In CompressionLevelText.Keys
                    Dim Value As String = CompressionLevelText(Key)
                    If String.Equals(str, Value) Then Return Key
                Next
                Return RarCompressionLv.Normal
            End Function

            Public Shared RarPath As String

            Private _nLv As RarCompressionLv
            Private _nRR As Integer
            Private _nThread As Integer
            Private _IgnoreExt As String
            Private _StoreExt As String

            Public Sub New()
                _nLv = RarCompressionLv.Normal
                _nRR = RECOVERYRECORD_DEF
                _nThread = THREAD_DEF
                _IgnoreExt = Nothing
                _StoreExt = Nothing
            End Sub

            Public Sub New(ByRef src As RarOptionConfig)
                Me.New()
                If src Is Nothing Then Return
                _nLv = src._nLv
                _nRR = src._nRR
                _nThread = src._nThread
                If String.IsNullOrWhiteSpace(src._IgnoreExt) = False Then _IgnoreExt = String.Copy(src._IgnoreExt)
                If String.IsNullOrWhiteSpace(src._StoreExt) = False Then _StoreExt = String.Copy(src._StoreExt)
            End Sub

            Public Property nLv As RarCompressionLv
                Get
                    nLv = _nLv
                End Get
                Set(ByVal value As RarCompressionLv)
                    _nLv = Math.Min(Math.Max(value, RarCompressionLv.None), RarCompressionLv.BestCompress)
                End Set
            End Property

            Public Property nRecoveryRecord As Integer
                Get
                    nRecoveryRecord = _nRR
                End Get
                Set(ByVal value As Integer)
                    _nRR = Math.Min(Math.Max(value, RECOVERYRECORD_MIN), RECOVERYRECORD_MAX)
                End Set
            End Property

            Public Property nThread As Integer
                Get
                    nThread = _nThread
                End Get
                Set(ByVal value As Integer)
                    _nThread = Math.Min(Math.Max(value, THREAD_MIN), THREAD_MAX)
                End Set
            End Property

            Public Property IgnoreExt As String
                Get
                    IgnoreExt = _IgnoreExt
                End Get
                Set(ByVal value As String)
                    _IgnoreExt = Nothing
                    If Not value Is Nothing Then _IgnoreExt = New Logic.FileSystem.Extention.Collection(value).ToString
                End Set
            End Property

            Public Property StoreExt As String
                Get
                    StoreExt = _StoreExt
                End Get
                Set(ByVal value As String)
                    _StoreExt = Nothing
                    If Not value Is Nothing Then _StoreExt = New Logic.FileSystem.Extention.Collection(value).ToString
                End Set
            End Property

            Public Function IgnoreExtSwitch() As String
                IgnoreExtSwitch = ExtJoin(New Logic.FileSystem.Extention.Collection(IgnoreExt).ToArray, "-x*.", " ")
            End Function

            Public Function StoreExtSwitch() As String
                Return IIf(String.IsNullOrWhiteSpace(StoreExt), Nothing, "-ms" & StoreExt)
            End Function

            Public Overrides Function Extention() As Logic.FileSystem.Extention
                Return EXT
            End Function

            Public Overrides Function TextInformation() As String
                Dim AppendIgnoreExt As String = ""
                Dim AppendStoreExt As String = ""
                If Not String.IsNullOrWhiteSpace(_IgnoreExt) Then AppendIgnoreExt = " IgnoreExt=" & _IgnoreExt
                If Not String.IsNullOrWhiteSpace(_StoreExt) Then AppendStoreExt = " StoreExt=" & _StoreExt
                Return String.Format("RAR CompressLv={0} Thread={1} RR{2}%{3}{4}", CompressionLevelText(_nLv), _nThread, _nRR, AppendIgnoreExt, AppendStoreExt)
            End Function

            Public Overrides Function Clone() As Object
                Return New RarOptionConfig(Me)
            End Function

            Public Overrides Function CreateProcess(Optional ByVal AppBase As AppBase = Nothing, Optional ByVal IsStopReq As Logic.Threading.SignalHandler = Nothing) As ArchiveProcess
                Return New RarProcess(Me, AppBase, IsStopReq)
            End Function
        End Class

    End Class
End Class

