/*
 * Copyright (C) 2007 u6k.yu1@gmail.com, All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of Clarkware Consulting, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without prior written permission. For written
 *       permission, please contact clarkware@clarkware.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CLARKWARE CONSULTING OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN  ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.gr.java_conf.u6k.filelock;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

/**
 * <p>
 * アプリケーションのエントリーポイントです。
 * </p>
 * 
 * @version $Id$
 */
final class ConsoleMain {

    private ConsoleMain() {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * アプリケーションのエントリーポイントです。
     * </p>
     * 
     * @param args
     *            アプリケーション引数。
     * @throws IOException
     *             ファイルのロックに失敗した場合。
     */
    public static void main(String[] args) throws IOException {
        FileLockUtil flu = new FileLockUtil(args);

        Map<String, Boolean> lockStateMap = new TreeMap<String, Boolean>();
        for (String path : flu.lockFiles()) {
            lockStateMap.put(path, true);
        }
        for (String path : flu.lockFailFiles()) {
            lockStateMap.put(path, false);
        }

        for (Map.Entry<String, Boolean> entry : lockStateMap.entrySet()) {
            if (entry.getValue()) {
                System.out.println(ResourceUtil.get("message.lock") + " " + entry.getKey());
            } else {
                System.out.println(ResourceUtil.get("message.fail") + " " + entry.getKey());
            }
        }

        System.in.read();
    }

}
