package filebookmark.view;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class BookmarkTransfer extends ByteArrayTransfer {

    private static final String TYPE_NAME = "bookmark-transfer" + (new Long(System.currentTimeMillis())).toString(); //$NON-NLS-1$;

    private static final int TYPEID = registerType(TYPE_NAME);
    
    private static final BookmarkTransfer INSTANCE = new BookmarkTransfer();
   
    private ISelection selection;

    private long selectionSetTime;

    public static BookmarkTransfer getTransfer() {
        return INSTANCE;
    }
    
    public ISelection getSelection() {
        return selection;
    }

    private boolean isInvalidNativeType(Object result) {
        return !(result instanceof byte[])
                || !TYPE_NAME.equals(new String((byte[]) result));
    }

    protected int[] getTypeIds() {
        return new int[] { TYPEID };
    }

    protected String[] getTypeNames() {
        return new String[] { TYPE_NAME };
    }

    public void javaToNative(Object object, TransferData transferData) {
        byte[] check = TYPE_NAME.getBytes();
        super.javaToNative(check, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        Object result = super.nativeToJava(transferData);
        if (isInvalidNativeType(result)) {
//        	Policy.getLog().log(new Status(
//                            IStatus.ERROR,
//                            Policy.JFACE,
//                            IStatus.ERROR,
//                            JFaceResources.getString("LocalSelectionTransfer.errorMessage"), null)); //$NON-NLS-1$
        }
        return selection;
    }

    public void setSelection(ISelection s) {
        selection = s;
    }

    public long getSelectionSetTime() {
        return selectionSetTime;
    }

    public void setSelectionSetTime(long time) {
        selectionSetTime = time;
    }
}
