package filebookmark.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

import filebookmark.model.Bookmark;
import filebookmark.util.ElementType;
import filebookmark.util.FileBookmarkUtil;

public class ChangeAction implements IObjectActionDelegate, IViewActionDelegate {

	private ISelection selection;
	private boolean isCategory = false;
	private String oldName = ""; //$NON-NLS-1$
	private Bookmark selectItem;
	/**
	 * Constructor for Action1.
	 */
	public ChangeAction() {
		super();
	}
	
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {		
	}

	public void run(IAction action) {
		selectItem = (Bookmark)((IStructuredSelection)selection).getFirstElement();
		
		if(selectItem.getType() == ElementType.CATEGORY){
			isCategory = true;
		
		}else if(selectItem.getType() == ElementType.BOOKMARK){
			isCategory = false;
		}
		
		oldName = selectItem.getName();

		InputDialog newDialog = new InputDialog(Display.getDefault()
				.getActiveShell(), Messages.getString("ChangeAction.dialog_name_change"), Messages.getString("ChangeAction.dialog_name"), oldName, //$NON-NLS-1$ //$NON-NLS-2$
				new IInputValidator() {

					public String isValid(String newText) {
						if (newText.length() == 0) {
							return Messages.getString("ChangeAction.dialog_not_input_name"); //$NON-NLS-1$
						}else if(isCategory && "Bookmark".equals(oldName)){ //$NON-NLS-1$
							return Messages.getString("ChangeAction.dialog_not_root_change"); //$NON-NLS-1$
						}else if(isCategory 
								&& !FileBookmarkUtil.getRootCategory().exist(newText)
								&& !selectItem.getName().equals(newText)){
							return Messages.getString("ChangeAction.dialog_repetition_category"); //$NON-NLS-1$
						}
						return null;
					}

				}) {
			protected Point getInitialSize() {
				return new Point(270, 160);
			}
		};

		if (newDialog.open() == Window.OK) {
			selectItem.setName(newDialog.getValue());
			
			FileBookmarkUtil.writeXml();
			FileBookmarkUtil.refreshView();
		}
		
	}

	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

	public void init(IViewPart view) {
	}
}
