/*
 * Decompiled with CFR 0.152.
 */
package filebookmark.actions;

import filebookmark.actions.Messages;
import filebookmark.model.Category;
import filebookmark.util.FileBookmarkUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class CreateCategoryAction
implements IObjectActionDelegate,
IViewActionDelegate {
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Category category = (Category)((IStructuredSelection)this.selection).getFirstElement();
        InputDialog newDialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.getString("CreateCategoryAction.dialog_new_category"), Messages.getString("CreateCategoryAction.dialog.name"), "New Category", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() == 0) {
                    return Messages.getString("CreateCategoryAction.dialog_not_category");
                }
                if (!FileBookmarkUtil.getRootCategory().exist(newText)) {
                    return Messages.getString("CreateCategoryAction.dialog_repetition_category");
                }
                return null;
            }
        }){

            protected Point getInitialSize() {
                return new Point(270, 160);
            }
        };
        if (newDialog.open() == 0) {
            Category newCategory = new Category(newDialog.getValue());
            category.addChild(newCategory);
            FileBookmarkUtil.refreshView();
            FileBookmarkUtil.writeXml();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void init(IViewPart view) {
    }
}

