﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using FeedGenerator.lib;

namespace FeedGenerator.subform
{
    public partial class ConfigForm : Form
    {
        public Config config;

        public ConfigForm(Config config)
        {
            InitializeComponent();

            // Configオブジェクトの内容を保存する
            this.config = config;
            // オブジェクトの内容をフォームに表示
            refreshForm();
        }

        /// <summary>
        /// 保持しているconfigオブジェクトの内容をフォームに反映します
        /// </summary>
        private void refreshForm()
        {
            idCheckBox.Checked = config.isIdGenerate;
            urlCheckBox.Checked = config.isUrlGenerate;
            updateCheckBox.Checked = config.isUpdateGenerate;
            insertBrTagCheckBox.Checked = config.isInsertBrTag;
            fontStatusLabel.Text = this.config.contentFont.Name + ", " + this.config.contentFont.Size.ToString() + "px";
        }

        /// <summary>
        /// フォント変更ボタンを押したときの処理です
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void fontChangeButton_Click(object sender, EventArgs e)
        {
            DialogResult result = fontDialog.ShowDialog(this);
            if (result == DialogResult.OK)
            {
                this.config.contentFont = fontDialog.Font;
                refreshForm();
            }
        }

        /// <summary>
        /// OKボタンがクリックされた場合、チェックボックスの変更内容をオブジェクトに反映する
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void okButton_Click(object sender, EventArgs e)
        {
            config.isIdGenerate = idCheckBox.Checked;
            config.isUrlGenerate = urlCheckBox.Checked;
            config.isUpdateGenerate = updateCheckBox.Checked;
            config.isInsertBrTag = insertBrTagCheckBox.Checked;
        }

        private void cancelButton_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
