
; ------------------
; FF_SPECS.4th
; ------------------
; displays all FastForth specifications
PWR_STATE

[UNDEFINED] AND [IF]
CODE AND
AND @R15+,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] DUP [IF]
CODE DUP
BW1 SUB #2,R15
    MOV R14,0(R15)
    MOV @R13+,R0
ENDCODE

CODE ?DUP
CMP #0,R14
0<> ?GOTO BW1
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] OVER [IF]
CODE OVER
MOV R14,-2(R15)
MOV @R15,R14
SUB #2,R15
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] DROP [IF]
CODE DROP
MOV @R15+,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] SWAP [IF]
CODE SWAP
MOV @R15,R10
MOV R14,0(R15)
MOV R10,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] ROT [IF]
CODE ROT
MOV @R15,R10
MOV R14,0(R15)
MOV 2(R15),R14
MOV R10,2(R15)
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] >R [IF]
CODE >R
PUSH R14
MOV @R15+,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] R> [IF]
CODE R>
SUB #2,R15
MOV R14,0(R15)
MOV @R1+,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] 0< [IF]
CODE 0<
ADD R14,R14
SUBC R14,R14
XOR #-1,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] = [IF]
CODE =
SUB @R15+,R14
0<> IF
    AND #0,R14
    MOV @R13+,R0
THEN
XOR #-1,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] U< [IF]
CODE U<
SUB @R15+,R14
0<> IF
    MOV #-1,R14
    U< IF
        AND #0,R14
    THEN
THEN
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] IF [IF]
CODE IF
SUB #2,R15
MOV R14,0(R15)
MOV &$1DC6,R14
ADD #4,&$1DC6
MOV #$404C,0(R14)
ADD #2,R14
MOV @R13+,R0
ENDCODE IMMEDIATE
[THEN]

[UNDEFINED] ELSE [IF]
CODE ELSE
ADD #4,&$1DC6
MOV &$1DC6,R10
MOV #$4048,-4(R10)
MOV R10,0(R14)
SUB #2,R10
MOV R10,R14
MOV @R13+,R0
ENDCODE IMMEDIATE
[THEN]

[UNDEFINED] THEN [IF]
CODE THEN
MOV &$1DC6,0(R14)
MOV @R15+,R14
MOV @R13+,R0
ENDCODE IMMEDIATE
[THEN]

[UNDEFINED] UNTIL [IF]
CODE UNTIL
    MOV #$404C,R9
BW1 ADD #4,&$1DC6
    MOV &$1DC6,R10
    MOV R9,-4(R10)
    MOV R14,-2(R10)
    MOV @R15+,R14
    MOV @R13+,R0
ENDCODE IMMEDIATE
[THEN]

[UNDEFINED] AGAIN [IF]
CODE AGAIN
MOV #$4048,R9
GOTO BW1
ENDCODE IMMEDIATE
[THEN]

[UNDEFINED] WHILE [IF]
: WHILE
POSTPONE IF SWAP
; IMMEDIATE
[THEN]

[UNDEFINED] REPEAT [IF]
: REPEAT
POSTPONE AGAIN POSTPONE THEN
; IMMEDIATE
[THEN]

[UNDEFINED] DO [IF]
CODE DO
SUB #2,R15
MOV R14,0(R15)
ADD #2,&$1DC6
MOV &$1DC6,R14
MOV #$4056,-2(R14)
ADD #2,&$1C00
MOV &$1C00,R10
MOV #0,0(R10)
MOV @R13+,R0
ENDCODE IMMEDIATE
[THEN]

[UNDEFINED] I [IF]
CODE I
SUB #2,R15
MOV R14,0(R15)
MOV @R1,R14
SUB 2(R1),R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] LOOP [IF]
CODE LOOP
    MOV #$4078,R9
BW1 ADD #4,&$1DC6
    MOV &$1DC6,R10
    MOV R9,-4(R10)
    MOV R14,-2(R10)
BEGIN
    MOV &$1C00,R14
    SUB #2,&$1C00
    MOV @R14,R14
    CMP #0,R14
0<> WHILE
    MOV R10,0(R14)
REPEAT
    MOV @R15+,R14
    MOV @R13+,R0
ENDCODE IMMEDIATE
[THEN]

[UNDEFINED] +LOOP [IF]
CODE +LOOP
MOV #$4066,R9
GOTO BW1
ENDCODE IMMEDIATE
[THEN]

[UNDEFINED] HERE [IF]
CODE HERE
MOV #BEGIN,R0
ENDCODE
[THEN]

[UNDEFINED] @ [IF]
CODE @
MOV @R14,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] ! [IF]
CODE !
MOV @R15+,0(R14)
MOV @R15+,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] C@ [IF]
CODE C@
MOV.B @R14,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] SPACES [IF]
CODE SPACES
CMP #0,R14
0<> IF
    PUSH R13
    BEGIN
        LO2HI
        $20 EMIT
        HI2LO
        SUB #2,R13 
        SUB #1,R14
    0= UNTIL
    MOV @R1+,R13
THEN
MOV @R15+,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] 1+ [IF]
CODE 1+
ADD #1,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] + [IF]
CODE +
ADD @R15+,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] - [IF]
CODE -
SUB @R15+,R14
XOR #-1,R14
ADD #1,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] 2* [IF]
CODE 2*
ADD R14,R14
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] UM/MOD [IF]
CODE UM/MOD
    PUSH #DROP
    MOV #$407E,R0
ENDCODE
[THEN]

[UNDEFINED] MOVE [IF]
CODE MOVE
MOV R14,R10
MOV @R15+,R8
MOV @R15+,R9
MOV @R15+,R14
CMP #0,R10
0<> IF
    CMP R9,R8
    0<> IF
        U< IF
            BEGIN
                MOV.B @R9+,0(R8)
                ADD #1,R8
                SUB #1,R10
            0= UNTIL
            MOV @R13+,R0
        THEN
        ADD R10,R8
        ADD R10,R9
        BEGIN
            SUB #1,R9
            SUB #1,R8
            MOV.B @R9,0(R8)
            SUB #1,R10
        0= UNTIL
    THEN
THEN
MOV @R13+,R0
ENDCODE
[THEN]

[UNDEFINED] WORDS [IF]
: WORDS
CR 
$1DCA @ $1CE4
$1800 @ 2*
MOVE
BEGIN
    0 DUP
    $1800 @ 2* 0
        DO
        DUP I $1CE4 + @
            U< IF
                DROP DROP
                I DUP $1CE4 + @
            THEN
        2 +LOOP
    ?DUP
WHILE
    DUP
    2 - @
    ROT
    $1CE4 +
    !
    DUP
    COUNT $7F AND
    TYPE
    C@ $0F AND
    $10 SWAP - SPACES
REPEAT
DROP
;
[THEN]

[UNDEFINED] CASE [IF]
: CASE 0 ; IMMEDIATE
[THEN]

[UNDEFINED] OF [IF]
: OF
1+	
>R	
POSTPONE OVER POSTPONE =
POSTPONE IF	
POSTPONE DROP	
R>	
; IMMEDIATE 
[THEN]

[UNDEFINED] ENDOF [IF]
: ENDOF
>R	
POSTPONE ELSE 
R>	
; IMMEDIATE 
[THEN]

[UNDEFINED] ENDCASE [IF]
: ENDCASE
POSTPONE DROP
0 DO 
    POSTPONE THEN 
LOOP 
; IMMEDIATE 
[THEN]

[UNDEFINED] ESC" [IF]
: ESC"
$1B
POSTPONE LITERAL
POSTPONE EMIT
POSTPONE S"
POSTPONE TYPE
; IMMEDIATE
[THEN]

: SPECS
PWR_STATE
HERE
ECHO

42 0 DO CR LOOP
ESC" [H"

ESC" [7m"
CR ." FastForth V"
$1810 @         
0 <# #  8 HOLD # 46 HOLD #S #> TYPE
."  for MSP430FR"
$1A04 @
CASE
    $8102     OF      ." 5738,"   $C200   ENDOF
    $8103     OF      ." 5739,"   $C200   ENDOF
    $8160     OF      ." 5948,"   $4400   ENDOF
    $8169     OF      ." 5969,"   $4400   ENDOF
    $81A8     OF      ." 6989,"   $4400   ENDOF
    $81F0     OF      ." 4133,"   $C400   ENDOF
    $8240     OF      ." 2433,"   $C400   ENDOF
    $82A1     OF      ." 5994,"   $4000   ENDOF
    $830C     OF      ." 2355,"   $8000   ENDOF
    $8328     OF      ." 2476,"   $8000   ENDOF
    ABORT" xxxx <-- unrecognized device!"
ENDCASE
$20 EMIT 
['] ['] DUP @ $1287 =
IF ." DTC=1," DROP
ELSE 2 + @ $1287 =
    IF ." DTC=2,"
    ELSE ." DTC=3,"
    THEN
THEN
$20 EMIT 
$1800 @ U. #8 EMIT ." -Entry word sets, "
$1806 @ 0 1000 UM/MOD U.
?DUP IF #8 EMIT ." ," U.
THEN ." MHz, "
- U. ." bytes"
ESC" [0m"

CR ." /COUNTED-STRING   = 255"
CR ." /HOLD             = 34"
CR ." /PAD              = 84"
CR ." ADDRESS-UNIT-BITS = 16"
CR ." FLOORED           = true"
CR ." MAX-CHAR          = 255"
CR ." MAX-N             = 32767"
CR ." MAX-U             = 65535"
CR ." MAX-D             = 2147483647"
CR ." MAX-UD            = 4294967295"
CR ." STACK-CELLS       = 48"
CR ." RETURN-STACK-CELLS= 48"

CR CR 

ESC" [7m"
." KERNEL ADDONS"
ESC" [0m"
$1812 @
    DUP 0< IF CR ." 32.768kHz XTAL" THEN
2*  DUP 0< IF 2* CR ." 5 WIRES (RTS/CTS) UART TERMINAL"
        ELSE 2* DUP
            0< IF CR ." 4 WIRES (RTS) UART TERMINAL" 
            THEN
        THEN
2*  DUP 0< IF CR ." 3 WIRES (XON/XOFF) UART TERMINAL" THEN
2*  DUP 0< IF CR ." HALF-DUPLEX TERMINAL" THEN
2*  DUP 0< IF CR ." ASM DATA ACCESS BEYOND $FFFF" THEN
2*  DUP 0< IF CR ." BOOTLOADER" THEN
2*  DUP 0< IF CR ." SD_CARD READ/WRITE" THEN
2*  DUP 0< IF CR ." SD_CARD LOADER" THEN
2*  DUP 0< IF CR ." FIXPOINT INPUT" THEN
2*  DUP 0< IF CR ." DOUBLE INPUT" THEN
2*  DUP 0< IF CR ." VOCABULARY SET" THEN
2*  DUP 0< IF CR ." NONAME" THEN
2*  DUP 0< IF CR ." EXTENDED ASSEMBLER" THEN
2*  DUP 0< IF CR ." ASSEMBLER" THEN
2*  DUP 0< IF CR ." CONDITIONNAL COMPILATION" THEN
0< IF
    CR CR ESC" [7m" 
    ." OPTIONS"
    ESC" [0m" CR
    [DEFINED] {CORE_COMP} [IF] ." CORE COMPLEMENT" CR [THEN]
    [DEFINED] {TOOLS}     [IF] ." UTILITY" CR [THEN]
    [DEFINED] {FIXPOINT}  [IF] ." FIXPOINT" CR [THEN]
    [DEFINED] {CORDIC}    [IF] ." CORDIC engine" CR [THEN]
    [DEFINED] {SD_TOOLS}  [IF] ." SD_TOOLS" CR [THEN]
    [DEFINED] {RTC}       [IF] ." RTC utilities" CR [THEN]
    CR
    [DEFINED] VOCABULARY [IF]
    ESC" [7m"
    ." ASSEMBLER word set"
    ESC" [0m"
    ALSO ASSEMBLER WORDS PREVIOUS CR
    [THEN]
THEN
    ESC" [7m"
    ." FORTH word set"
    ESC" [0m"
    WORDS

CR WARM
;

SPECS
