<?php
class eXmasCakeComponent extends Object{

	var $GeneralConst = array(
		'TOP' => 'トップページ',
        'ADD' => '登録',
        'EDIT' => '編集',
        'DEL' => '削除',
        'VIEW' => '詳細',
        'LOOKUP' => '一覧',
        'MENU' => 'メニュー',
        'ACTION' => '操作',
        'SUBMIT' => '登録',
        'PREV' => '前へ',
        'NEXT' => '次へ',
        'PAGE_NAVI' => 'ページ {:page}/{:pages}  (全 {:count} 件)',
        'CONFIRM' => '%sを%sしますか',
        'SAVE_OK' => '保存しました',
        'SAVE_NG' => '保存できませんでした',
        'DEL_OK' => '削除しました',
        'DEL_NG' => '削除できませんでした',
        'INVALID_ID' => 'データに誤りがあります',
        'NOTEXISTS' => 'データが見つかりませんでした',
        'UNIQUE_NG' => '同一名称のデータは登録できません',
        'ID' => '登録番号',
        'NAME' => '名称',
        'ACTIVE' => '有効',
        'INACTIVE' => '無効',
        'CREATED' => '作成日',
        'MODIFIED' => '更新日',
        'DESCRIPTION' => 'メモ',
        'LOGIN' => 'ログイン',
        'LOGOUT' => 'ログアウト',
        'STATUS' => '状態',
        'GO_BACK' => '戻る',
        'RELATED_DATA' => '連携データ'
	);

    var $numeric = array(
            'int',
            'smallint',
            'integer',
            'bigint',
            'decimal',
            'numeric',
            'real',
            'double precision',
            'serial',
            'bigserial'
        );

	function initialize() { }
	function startup() { }
	function beforeRender() { }
	function shutdown() { }
    function beforeRedirect() { }

	public function rmrf($dir) {
		foreach (glob($dir) as $file) {
			if (is_dir($file)) {
				$this->rmrf("$file/*");
				rmdir($file);
			} else {
				unlink($file);
			}
		}
	}	

	public function createFolder($path) {
		$this->rmrf($path);
	
		mkdir($path);
		mkdir($path.DS.'Config');
		mkdir($path.DS.'Controller');
		mkdir($path.DS.'Model');
		mkdir($path.DS.'View');
	}

	public function copyConstants($path) {
		$source = APP.DS.'Config'.DS.'bootstrap.php';
		$dist = $path.DS.'Config'.DS.'bootstrap.php';
		copy($source,$dist);
		
		$source = APP.DS.'Model'.DS.'AppModel.php';
		$dist = $path.DS.'Model'.DS.'AppModel.php';
		copy($source,$dist);
	}

	public function getDbScript($db) {
		$spt = '<?php'.PHP_EOL;
        $spt .= 'class DATABASE_CONFIG {'.PHP_EOL;
        $spt .= SP1.'public $default = array('.PHP_EOL;
        $spt .= SP2."'datasource' => 'Database/Postgres',".PHP_EOL;
        $spt .= SP2."'persistent' => false,".PHP_EOL;
        $spt .= SP2."'host' => '".$db['db_host']."',".PHP_EOL;
        $spt .= SP2."'login' => '".$db['db_user']."',".PHP_EOL;
        $spt .= SP2."'password' => '".$db['db_password']."',".PHP_EOL;
        $spt .= SP2."'database' => '".$db['db_name']."',".PHP_EOL;
        $spt .= SP2."'encoding' => 'utf8',".PHP_EOL;
        $spt .= SP1.");".PHP_EOL;
        $spt .= "}".PHP_EOL;
        return $spt;
	}

	public function getTableSql($dbTable) {
		$names = $this->getNames($dbTable['DbTable']);

		$spt = '-- drop table '.$names['TableName'].';'.PHP_EOL;
		$spt .= '-- '.$names['TableName'].' テーブル'.PHP_EOL;
		if (!empty($dbTable['TableField'])) {
        	$spt .= 'create table '.$names['TableName'].' ('.PHP_EOL;
			$fields = $dbTable['TableField'];
			foreach ($fields as $tableField) {
				$spt .=SP1.$tableField['symbol'].' '.$tableField['field_type'].' '.$tableField['field_option'];
				if ($tableField['default_value'] != null) {
					$spt .= ' default '.$tableField['default_value'];
				}
				$spt .= ', -- '.$tableField['name'].PHP_EOL;
			}
			$spt .= 'primary key (id)'.PHP_EOL;
			$spt .= ');';
		}
		return $spt;
	}

	public function getNames($dbTable) {
		$names = array();
		$names['TableName'] = $dbTable['symbol'];
		$names['ClassName'] = Inflector::classify($dbTable['symbol']);
		$names['Property'] = Inflector::camelize($dbTable['symbol']);
//		$names['DisplayField'] = $this->getDisplayField($dbTable);		
		$names['Controller'] = $names['Property']."ontroller";
		$names['Model'] = $names['ClassName']; 
		$names['property'] = strtolower($names['Property']);
		$names['PROPERTY'] = strtoupper($names['Property']);
		$names['classname'] = strtolower($names['ClassName']);
		$names['CLASSNAME'] = strtoupper($names['ClassName']);
		$names['symbol'] = Inflector::underscore($dbTable['symbol']);

		return $names;
	}

	public function getDisplayField($tableFields) {
		if (!empty($tableFields)) {
			foreach ($tableFields as $tableField) {
				if (preg_match("/name/", $tableField['symbol'])) {
					return $tableField['symbol'];
				}
			}
		}
		return 'id';
	}

	public function getStem($data){
		$data = strtolower($data);
		$pos = strpos($data,'(');
		if ($pos>0) {
			return   substr(0,$pos);
		} else {
			return $data;
		}
	}

	public function generateBelongsTo($tableField) {
		$belongsto = $this->getBelongsTo($tableField);
		$belong = "";
		if (!empty($belongsto)) {
			$belong = SP1."public $"."belongsTo = array(".PHP_EOL;

			foreach($belongsto as $data) {
				foreach ($data as $key=>$value) {
					$table = $value[0];
					$field = $value[1];
					$belong .= SP2."'$table' => array(".PHP_EOL;
					$belong .= SP3."'className' => '$table',".PHP_EOL;
					$belong .= SP3."'foreignKey' => '$key',".PHP_EOL;
					$belong .= SP3."'conditions' => '',".PHP_EOL;
					$belong .= SP3."'fields' => '',".PHP_EOL;
					$belong .= SP3."'order' => ''".PHP_EOL;
					$belong .= SP2."),".PHP_EOL;
				}
			}
			$belong .= SP1.");".PHP_EOL;
		}
		return $belong;
	}

	public function getBelongsTo($tableFields) {
		$belongs = array();
		foreach ($tableFields as $tableField) {
			$symbol =  $tableField['symbol'];
			$foreigntable = $tableField['foreign_table'];
			$foreignkey = $tableField['foreign_field'];
			if ($foreigntable != '') {
				$classify = Inflector::classify($foreigntable);
				$belongs[] = array($symbol=>array($classify,$foreignkey));
			}
		}
		return $belongs;
	}

	public function generateRules($tableFields) {
		$rules = SP1."public $"."validate = array(".PHP_EOL;
		foreach ($tableFields as $tableField) {
			$symbol =  $tableField['symbol'];
			$check = $this->getRule($tableField);
			if (count($check)) {
				$rules .= SP2."'$symbol' => array(".PHP_EOL;
				foreach($check as $value) {
					list($rule,$message) = $value;
					$rules .= SP3."'$rule' => array(".PHP_EOL;
					$rules .= SP4."'rule' => array('$rule'),".PHP_EOL;
					$rules .= SP4."'message' => $message,".PHP_EOL;
					$rules .= SP3."),".PHP_EOL;
				}
				$rules .= SP2."),".PHP_EOL;
			}
		}
		$rules .= SP1.");".PHP_EOL;
		return $rules;
	}

	public function getRule($tableField) {
		$type = $tableField['field_type'];
		$option = $tableField['field_option'];
		$check = array();
		$stem = $this->getStem($type);
		if (in_array($stem,$this->numeric)) {
			$check[] = array('numeric','NUMERIC');
		}
		if ($stem == 'date') {
			$check[] = array('date','DATE_TYPE');
		}
		if ($option == 'not null') {
			$check[] = array('notempty','NOTEMPTY');
		}
		return $check;
	}

	public function getHasmanies($hasmanies) {
		$hasmany = "";
		if (!empty($hasmanies)) {
			$hasmany = SP1.'public $hasMany = array('.PHP_EOL;
			foreach ($hasmanies as $row) {
				$table = Inflector::classify($row['table_name']);
				$field = $row['field_name'];
				$hasmany .= SP2."'$table' => array(".PHP_EOL;
				$hasmany .= SP3."'className' => '$table',".PHP_EOL;
				$hasmany .= SP3."'foreignKey' => '$field',".PHP_EOL;
				$hasmany .= SP3."'dependent' => false,".PHP_EOL;
				$hasmany .= SP3."'conditions' => '',".PHP_EOL;
				$hasmany .= SP3."'fields' => '',".PHP_EOL;
				$hasmany .= SP3."'order' => '',".PHP_EOL;
				$hasmany .= SP3."'limit' => '',".PHP_EOL;
				$hasmany .= SP3."'offset' => '',".PHP_EOL;
				$hasmany .= SP3."'exclusive' => '',".PHP_EOL;
				$hasmany .= SP3."'finderQuery' => '',".PHP_EOL;
				$hasmany .= SP3."'counterQuery' => ''".PHP_EOL;
				$hasmany .= SP2."),".PHP_EOL;
			}
			$hasmany .= SP1.");".PHP_EOL;
		}
		return $hasmany;
	}

	public function getModel($names,$rules,$belongs,$hasmany) {
		$str = "<?php".PHP_EOL;
		$str .= "App::uses('AppModel', 'Model');".PHP_EOL;
		$str .= "/**".PHP_EOL;
		$str .= " * ".$names['ClassName']." Model".PHP_EOL;
		$str .= " *".PHP_EOL;
		$str .= " * @property  ".$names['Property']." $".$names['Property'].PHP_EOL;
		$str .= " */".PHP_EOL;
		$str .= "class ".$names['ClassName']." extends AppModel {".PHP_EOL;
		if (isset($names['DisplayField'])) {
			$str .= SP1."/**".PHP_EOL;
			$str .= SP1." * Display field".PHP_EOL;
			$str .= SP1." *".PHP_EOL;
			$str .= SP1." * @var string".PHP_EOL;
			$str .= SP1." */".PHP_EOL;
			$str .= SP1."public $"."displyField = '".$names['DisplayField']."';".PHP_EOL;
		}
		if (!empty($rules)) {
			$str .= SP1."/**".PHP_EOL;
			$str .= SP1." * Validation rules".PHP_EOL;
			$str .= SP1." *".PHP_EOL;
			$str .= SP1." * @var array".PHP_EOL;
			$str .= SP1." */".PHP_EOL;
			$str .= $rules.PHP_EOL;
		}
		if (!empty($belongs)) {
			$str .= SP1."/**".PHP_EOL;
			$str .= SP1." * belongsTo associations".PHP_EOL;
			$str .= SP1." *".PHP_EOL;
			$str .= SP1." * @var array".PHP_EOL;
			$str .= SP1." */".PHP_EOL;
			$str .= $belongs.PHP_EOL;
		}
		if (!empty($hasmany)) {
			$str .= SP1."/**".PHP_EOL;
			$str .= SP1." * hasMany associations".PHP_EOL;
			$str .= SP1." *".PHP_EOL;
			$str .= SP1." * @var array".PHP_EOL;
			$str .= SP1." */".PHP_EOL;
			$str .= $hasmany.PHP_EOL;
		}
		$str .= '}';
		return $str;
	}

	public function getClassDiv($name,$action) {
		if ($action == 'add' || $action == 'edit') {
			return "<div class='$name form'>";
		} else {
			return "<div class='$name $action'>";
		}
	}
	public function getTitle($name,$action) {
		return "<h2><?php echo $name.$action; ?></h2>";
	}
	public function getTable($names,$dbTable) {
		
		$str = "<table cellpadding=\"0\" cellspacing=\"0\">".PHP_EOL;
		if(!empty($dbTable)) {
			$displayName = 'id';
			$str .= SP1."<tr>".PHP_EOL;
			foreach ($dbTable['TableField'] as $tableField) {
				$str .= SP2.'<th><?php echo $this->Paginator->sort(\''.$tableField['symbol'].'\','.strtoupper($tableField['symbol']).'); ?></th>'.PHP_EOL;
				if ($displayName == 'id') {
					if (preg_match("/name/",$tableField['symbol'])) {
						$displayName = $tableField['symbol'];
					}
				}
			}
			$str .= SP2."<th class=\"actions\"><?php echo ACTION; ?></th>".PHP_EOL;
			$str .= SP1."</tr>".PHP_EOL;
			$str .= "<?php foreach ($".$names['property']." as $".$names['classname']."): ?>".PHP_EOL;
			$str .= SP1."<tr>".PHP_EOL;
			foreach ($dbTable['TableField'] as $tableField) {
				$str .= SP2."<td><?php echo h($".$names['classname']."['".$names['ClassName']."']['".$tableField['symbol']."']); ?>&nbsp;</td>".PHP_EOL;
			}	
			$str .= SP2.'<td class="actions">'.PHP_EOL;
			$str .= '<?php echo $this->Html->link(VIEW, array(\'action\' => \'view\',$'.$names['classname']."['".$names['ClassName']."']['id'])); ?>".PHP_EOL;
			$str .= '<?php echo $this->Html->link(EDIT, array(\'action\' => \'edit\', $'.$names['classname']."['".$names['ClassName']."']['id'])); ?>".PHP_EOL;
			$str .= '<?php echo $this->Form->postLink(DEL,array(\'action\' => \'delete\','.PHP_EOL;
			$str .= SP3.' $'.$names['classname']."['".$names['ClassName']."']['id']), null, __(CONFIRM,$".$names['classname']. "['" .$names['ClassName']."']['".$displayName."'],DEL)); ?>".PHP_EOL;
			$str .= SP2.'</td>'.PHP_EOL;
			$str .= SP1.'</tr>'.PHP_EOL;
			$str .= '<?php endforeach; ?>'.PHP_EOL;
			$str .= '</table>'.PHP_EOL;
		}
		return $str;
	}

	public function getPaginator() {
		$str = '<p>'.PHP_EOL;
		$str .= '<?php'.PHP_EOL;
		$str .= SP1.'$this->Paginator->counter(array(\'format\' => PAGE_NAVI));'.PHP_EOL;
		$str .= '?>  </p>'.PHP_EOL;
		$str .= '<div class="paging">'.PHP_EOL;
		$str .= '<?php'.PHP_EOL;
		$str .= SP1.'echo $this->Paginator->prev(\'< \' . PREV, array(), null, array(\'class\' => \'prev disabled\'));'.PHP_EOL;
		$str .= SP1.'echo $this->Paginator->numbers(array(\'separator\' => \'\'));'.PHP_EOL;
		$str .= SP1.'echo $this->Paginator->next(NEXT . \' >\', array(), null, array(\'class\' => \'next disabled\'));'.PHP_EOL;
		$str .= '?>'.PHP_EOL; 
		$str .= '</div>'.PHP_EOL;
		return $str;
	}

	public function getDl($names,$dbTable) {
		$str = '<dl>'.PHP_EOL;
		if(!empty($dbTable['TableField'])) {
			foreach ($dbTable['TableField'] as $tableField) {
				$str .= SP1.'<dt><?php echo '.strtoupper($tableField['symbol']).'; ?></dt>'.PHP_EOL;
				$str .= SP1.'<dd>'.PHP_EOL;
				if ($tableField['field_type'] == 'text') {
					$str .= SP2.'<?php echo nl2br(h($'.$names['classname'].'[\''.$names['ClassName'].'\'][\''.$tableField['symbol'].'\'])); ?>'.PHP_EOL;
				} else {
					$str .= SP2.'<?php echo h($'.$names['classname'].'[\''.$names['ClassName'].'\'][\''.$tableField['symbol'].'\']); ?>'.PHP_EOL;
				}
				$str .= SP2.'&nbsp;'.PHP_EOL;
				$str .= SP1.'</dd>'.PHP_EOL;
			}
		}
		$str .= '<dl>'.PHP_EOL;
		return $str;
	}
	public function getInput($names,$dbTable,$mode) {
		$str = '<?php echo $this->Form->create(\''.$names['Model'].'\'); ?>'.PHP_EOL;
		$str .= SP1.'<fieldset>'.PHP_EOL;
		$str .= SP2.'<legend><?php echo '.$names['PROPERTY'].'.ADD; ?></legend>'.PHP_EOL;
		$str .= SP1.'<?php'.PHP_EOL;

		if(!empty($dbTable['TableField'])) {
			foreach ($dbTable['TableField'] as $tableField) {
				if (strtolower($tableField['symbol']) != 'id' || $mode == 'edit') {
					if (strtolower($tableField['field_type'] != 'timestamp')) {
						$str .=SP1.'echo $this->Form->input(\''.$tableField['symbol']."',array('label'=>".strtoupper($tableField['symbol']);
						if (strtolower($tableField['field_type']) == 'date') {
							$str .= ",'type'=>'date','dateFormat' => 'YMD','monthNames'=>false";
						}
						$str .= "));".PHP_EOL;
					}
				}
			}
		}
		$str .= SP1.'?>'.PHP_EOL;
		$str .= SP1.'</fieldset>'.PHP_EOL;
		$str .= '<?php echo $this->Form->end(SUBMIT); ?>'.PHP_EOL;

		return $str;
	}

	public function getMenu($names,$menus) {
		$str = '<div class="actions">'.PHP_EOL;
		$str .= '<h3><?php echo MENU; ?></h3>'.PHP_EOL;
		$str .= SP1.'<ul>'.PHP_EOL;
		if (in_array('add',$menus)) {
			$str .= SP2.'<li><?php echo $this->Html->link('.$names['PROPERTY'].'.ADD, array(\'action\' => \'add\')); ?></li>'.PHP_EOL;
		}
		if (in_array('edit',$menus)) {
			$str .= '<li><?php echo $this->Html->link('.$names['PROPERTY'].".EDIT, array('action' => 'edit',$". $names['classname']."['".$names['ClassName']."']['id'])); ?></li>".PHP_EOL;
		}
		if (in_array('delete',$menus)) {
$str .= '<li><?php echo $this->Form->postLink('.$names['PROPERTY'].'.DEL,array(\'action\' => \'delete\','.PHP_EOL;
            $str .= SP3.' $'.$names['classname']."['".$names['ClassName']."']['id']), null, __(CONFIRM,$".$names['classname']. "['" .$names['ClassName']."']['".$names['DisplayField']."'],DEL)); ?></li>".PHP_EOL;
		}
		if (in_array('lookup',$menus)) {
			$str .= '<li><?php echo $this->Html->link('.$names['PROPERTY'].'.LOOKUP, array(\'action\' => \'index\')); ?></li>'.PHP_EOL;

		}
		$str .= SP1.'</ul>'.PHP_EOL;
		$str .= '</div>'.PHP_EOL;
		return $str;
	}

	public function index_view($table) {
		$names = $this->getNames($table['DbTable']);
		$names['DisplayField'] = $this->getDisplayField($table['TableField']);
		$str = $this->getClassDiv($names['property'],'index').PHP_EOL;
		$str .= $this->getTitle($names['PROPERTY'],'LOOKUP').PHP_EOL;	
        $str .= $this->getTable($names,$table).PHP_EOL;
		$str .= $this->getPaginator().PHP_EOL;
		$str .= '</div>'.PHP_EOL;

		$str .= $this->getMenu($names,array('add'));
		return $str; 
	}

	public function view_view($table) {
		$names = $this->getNames($table['DbTable']);
        $names['DisplayField'] = $this->getDisplayField($table['TableField']);
		$str = $this->getClassDiv($names['property'],'view').PHP_EOL;
		$str .= $this->getTitle($names['PROPERTY'],'VIEW').PHP_EOL;
		$str .= $this->getDl($names,$table).PHP_EOL;
        $str .= '</div>'.PHP_EOL;

		$str .= $this->getMenu($names,array('edit','delete','lookup')).PHP_EOL;
		return $str;
	}
	public function add_view($table) {
        $names = $this->getNames($table['DbTable']);
        $names['DisplayField'] = $this->getDisplayField($table['TableField']);
		$str = $this->getClassDiv($names['property'],'add').PHP_EOL;
		$str .= $this->getInput($names,$table,'add').PHP_EOL;
        $str .= '</div>'.PHP_EOL;
		$str .= $this->getMenu($names,array('lookup')).PHP_EOL;
		return $str;
	}
	public function edit_view($table) {
        $names = $this->getNames($table['DbTable']);
        $names['DisplayField'] = $this->getDisplayField($table['TableField']);
		$str = $this->getClassDiv($names['property'],'edit').PHP_EOL;
		$str .= $this->getInput($names,$table,'edit');
        $str .= '</div>'.PHP_EOL;
		$str .= $this->getMenu($names,array('lookup')).PHP_EOL;
		return $str;
	}
	public function getIndexMethod($names) {
		$index = SP1.'public function index() {'.PHP_EOL;
		$index .= SP2.'$this->'.$names['ClassName'].'->recursive = 0;'.PHP_EOL;
		$index .= SP2.'$this->set(\''.$names['property'].'\', $this->paginate());'.PHP_EOL;
		$index .= SP1.'}'.PHP_EOL;
		return $index;
	}
	public function getViewMethod($names) {
		$view = SP1.'public function view($id = null) {'.PHP_EOL;
		$view .= SP2.'$this->'.$names['ClassName'].'->id = $id;'.PHP_EOL;
		$view .= SP2.'if (!$this->'.$names['ClassName'].'->exists()) {'.PHP_EOL;
		$view .= SP3.'throw new NotFoundException(INVALID_ID);'.PHP_EOL;
		$view .= SP2.'}'.PHP_EOL;
		$view .= SP2.'$this->set(\''.$names['classname'].'\', $this->'.$names['ClassName'].'->read(null, $id));'.PHP_EOL;
		$view .= SP1.'}';
		return $view;
	}
	public function getAddMethod($names,$belongs) {
		$add = SP1.'public function add() {'.PHP_EOL;
		$add .= SP2.'if ($this->request->is(\'post\')) {'.PHP_EOL;
		$add .= SP3.'$this->'.$names['Model'].'->create();'.PHP_EOL;
		$add .= SP3.'if ($this->'.$names['Model'].'->save($this->request->data)) {'.PHP_EOL;
		$add .= SP4.'$this->Session->setFlash(SAVE_OK);'.PHP_EOL;
		$add .= SP4.'$this->redirect(array(\'action\' => \'index\'));'.PHP_EOL;
		$add .= SP3.'} else {'.PHP_EOL;
		$add .= SP4.'$this->Session->setFlash(SAVE_NG);'.PHP_EOL;
		$add .= SP3.'}'.PHP_EOL;
		$add .= SP2.'}'.PHP_EOL;
		if (!empty($belongs)) {
			foreach($belongs as $data) {
				foreach ($data as $key=>$value) {
					$val = strtolower(Inflector::pluralize($value[0]));
					$add .= SP2.'$'.$val.' = $this->'.$names['Model'].'->'.Inflector::classify($value['0']).'->find(\'list\');'.PHP_EOL;
					$add .= SP2.'$this->set(compact(\''.$val.'\'));'.PHP_EOL;
				}
			}
		}
		$add .= SP1.'}'.PHP_EOL;
		return $add;
	}
	public function getEditMethod($names,$belongs) {
		$edit = SP1.'public function edit($id = null) {'.PHP_EOL;
		$edit .= SP2.'$this->'.$names['Model'].'->id = $id;'.PHP_EOL;
		$edit .= SP2.'if (!$this->'.$names['Model'].'->exists()) {'.PHP_EOL;
		$edit .= SP3.'throw new NotFoundException(INVALID_ID);'.PHP_EOL;
		$edit .= SP2.'}'.PHP_EOL;
		$edit .= SP2.'if ($this->request->is(\'post\') || $this->request->is(\'put\')) {'.PHP_EOL;
		$edit .= SP3.'if ($this->'.$names['Model'].'->save($this->request->data)) {'.PHP_EOL;
		$edit .= SP4.'$this->Session->setFlash(SAVE_OK);'.PHP_EOL;
		$edit .= SP4.'$this->redirect(array(\'action\' => \'index\'));'.PHP_EOL;
		$edit .= SP3.'} else {'.PHP_EOL;
		$edit .= SP4.'$this->Session->setFlash(SAVE_NG);'.PHP_EOL;
		$edit .= SP3.'}'.PHP_EOL;
		$edit .= SP2.'} else {'.PHP_EOL;
		$edit .= SP3.'$this->request->data = $this->'.$names['Model'].'->read(null, $id);'.PHP_EOL;
		$edit .= SP2.'}'.PHP_EOL;
		if (!empty($belongs)) {
			foreach($belongs as $data) {
				foreach ($data as $key=>$value) {
					$val = strtolower(Inflector::pluralize($value[0]));
					$edit .= SP2.'$'.$val.' = $this->'.$names['Model'].'->'.Inflector::classify($value['0']).'->find(\'list\');'.PHP_EOL;
					$edit .= SP2.'$this->set(compact(\''.$val.'\'));'.PHP_EOL;
				}
			}
		}
		$edit .= SP1.'}'.PHP_EOL;
		return $edit;
	}
	public function getDeleteMethod($names) {
		$delete = SP1.'public function delete($id = null) {'.PHP_EOL;
		$delete .= SP2.'if (!$this->request->is(\'post\')) {'.PHP_EOL;
		$delete .= SP3.'throw new MethodNotAllowedException();'.PHP_EOL;
		$delete .= SP2.'}'.PHP_EOL;
		$delete .= SP2.'$this->'.$names['Model'].'->id = $id;'.PHP_EOL;
		$delete .= SP2.'if (!$this->'.$names['Model'].'->exists()) {'.PHP_EOL;
		$delete .= SP3.'throw new NotFoundException(INVALID_ID);'.PHP_EOL;
		$delete .= SP2.'}'.PHP_EOL;
		$delete .= SP2.'if ($this->'.$names['Model'].'->delete()) {'.PHP_EOL;
		$delete .= SP3.'$this->Session->setFlash(DEL_OK);'.PHP_EOL;
		$delete .= SP3.'$this->redirect(array(\'action\' => \'index\'));'.PHP_EOL;
		$delete .= SP2.'}'.PHP_EOL;
		$delete .= SP2.'$this->Session->setFlash(DEL_NG);'.PHP_EOL;
		$delete .= SP1.'}'.PHP_EOL;
		return $delete;
	}

}
