/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammar.rule;

import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.grammar.EventInformation;
import com.siemens.ct.exi.grammar.SchemaLessEventInformation;
import com.siemens.ct.exi.grammar.event.Attribute;
import com.siemens.ct.exi.grammar.event.Event;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.rule.AbstractRule;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaLessRule;
import com.siemens.ct.exi.util.MethodsBag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSchemaLessRule
extends AbstractRule
implements SchemaLessRule {
    protected List<EventInformation> containers = new ArrayList<EventInformation>();
    protected int eventCount = 0;

    public final boolean isSchemaInformed() {
        return false;
    }

    public boolean hasSecondOrThirdLevel(FidelityOptions fidelityOptions) {
        return true;
    }

    public Rule getTypeEmpty() {
        return this;
    }

    public int get1stLevelEventCodeLength(FidelityOptions fidelityOptions) {
        return this.hasSecondOrThirdLevel(fidelityOptions) ? MethodsBag.getCodingLength(this.eventCount + 1) : MethodsBag.getCodingLength(this.eventCount);
    }

    public int getNumberOfEvents() {
        return this.containers.size();
    }

    public void addRule(Event event, Rule rule) {
        assert (!this.contains(event));
        this.containers.add(new SchemaLessEventInformation(this, rule, event, this.getNumberOfEvents()));
        this.eventCount = this.containers.size();
    }

    protected boolean contains(Event event) {
        Iterator<EventInformation> iter = this.containers.iterator();
        while (iter.hasNext()) {
            if (!iter.next().event.equals(event)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfSchemaDeviatedAttributes() {
        throw new RuntimeException("Schema-related attribute dealing in schema-less case");
    }

    public int getLeastAttributeEventCode() {
        throw new RuntimeException("Schema-related attribute dealing in schema-less case");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.getLabel()) + "//" + "\t");
        sb.append("[");
        int ec = 0;
        while (ec < this.getNumberOfEvents()) {
            sb.append("," + this.lookFor((int)ec).event);
            ++ec;
        }
        sb.append("]");
        return sb.toString();
    }

    public EventInformation lookForEvent(EventType eventType) {
        for (EventInformation ei : this.containers) {
            if (!ei.event.isEventType(eventType)) continue;
            return ei;
        }
        return null;
    }

    public EventInformation lookForStartElement(String namespaceURI, String localName) {
        for (EventInformation ei : this.containers) {
            if (!ei.event.isEventType(EventType.START_ELEMENT) || !AbstractSchemaLessRule.checkQualifiedName(((StartElement)ei.event).getQName(), namespaceURI, localName)) continue;
            return ei;
        }
        return null;
    }

    public EventInformation lookForStartElementNS(String namespaceURI) {
        return null;
    }

    public EventInformation lookForAttribute(String namespaceURI, String localName) {
        for (EventInformation ei : this.containers) {
            if (!ei.event.isEventType(EventType.ATTRIBUTE) || !AbstractSchemaLessRule.checkQualifiedName(((Attribute)ei.event).getQName(), namespaceURI, localName)) continue;
            return ei;
        }
        return null;
    }

    public EventInformation lookForAttributeNS(String namespaceURI) {
        return null;
    }

    public EventInformation lookFor(int eventCode) {
        assert (eventCode >= 0 && eventCode < this.containers.size());
        return this.containers.get(this.getNumberOfEvents() - 1 - eventCode);
    }
}

