/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io.channel;

import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.util.datatype.DatetimeType;
import com.siemens.ct.exi.util.datatype.XSDBoolean;
import com.siemens.ct.exi.util.datatype.XSDDatetime;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Calendar;

public abstract class AbstractEncoderChannel
implements EncoderChannel {
    public void encodeBinary(byte[] b) throws IOException {
        this.encodeUnsignedInteger(b.length);
        this.encode(b, 0, b.length);
    }

    public void encodeBoolean(XSDBoolean b) throws IOException, IllegalArgumentException {
        this.encodeBoolean(b.getBoolean());
    }

    public void encodeString(String s) throws IOException {
        this.encodeUnsignedInteger(s.length());
        this.encodeStringOnly(s);
    }

    public void encodeStringOnly(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (Character.isHighSurrogate(ch)) {
                this.encodeUnsignedInteger(Character.toCodePoint(ch, s.charAt(++i)));
            } else {
                this.encodeUnsignedInteger(ch);
            }
            ++i;
        }
    }

    public void encodeInteger(int n) throws IOException {
        if (n < 0) {
            this.encodeBoolean(true);
            this.encodeUnsignedInteger(-n - 1);
        } else {
            this.encodeBoolean(false);
            this.encodeUnsignedInteger(n);
        }
    }

    public void encodeLong(long l) throws IOException {
        if (l < 0L) {
            this.encodeBoolean(true);
            this.encodeUnsignedLong(-l - 1L);
        } else {
            this.encodeBoolean(false);
            this.encodeUnsignedLong(l);
        }
    }

    public void encodeBigInteger(BigInteger bi) throws IOException {
        if (bi.signum() < 0) {
            this.encodeBoolean(true);
            this.encodeUnsignedBigInteger(bi.negate().subtract(BigInteger.ONE));
        } else {
            this.encodeBoolean(false);
            this.encodeUnsignedBigInteger(bi);
        }
    }

    public void encodeUnsignedInteger(int n) throws IOException {
        if (n < 0) {
            throw new UnsupportedOperationException();
        }
        if (n < 128) {
            this.encode(n);
        } else {
            int n7BitBlocks = MethodsBag.numberOf7BitBlocksToRepresent(n);
            switch (n7BitBlocks) {
                case 5: {
                    this.encode(0x80 | n);
                    n >>>= 7;
                }
                case 4: {
                    this.encode(0x80 | n);
                    n >>>= 7;
                }
                case 3: {
                    this.encode(0x80 | n);
                    n >>>= 7;
                }
                case 2: {
                    this.encode(0x80 | n);
                    n >>>= 7;
                }
                case 1: {
                    this.encode(n);
                }
            }
        }
    }

    public void encodeUnsignedLong(long l) throws IOException {
        if (l < 0L) {
            throw new UnsupportedOperationException();
        }
        int lastEncode = (int)l;
        l >>>= 7;
        while (l != 0L) {
            this.encode(lastEncode | 0x80);
            lastEncode = (int)l;
            l >>>= 7;
        }
        this.encode(lastEncode);
    }

    public void encodeUnsignedBigInteger(BigInteger bi) throws IOException {
        if (bi.signum() < 0) {
            throw new UnsupportedOperationException();
        }
        int m = bi.bitLength() % 7;
        int nbytes = bi.bitLength() / 7 + (m > 0 ? 1 : 0);
        while (--nbytes > 0) {
            this.encode(0x80 | bi.intValue());
            bi = bi.shiftRight(7);
        }
        this.encode(bi.intValue());
    }

    public void encodeDecimal(BigDecimal decimal) throws IOException {
        if (decimal.signum() < 0) {
            decimal = decimal.abs();
            this.encodeBoolean(true);
        } else {
            this.encodeBoolean(false);
        }
        BigDecimal integral = decimal.setScale(0, RoundingMode.FLOOR);
        this.encodeUnsignedBigInteger(integral.toBigInteger());
        BigDecimal fractional = integral.signum() < 0 ? decimal.add(integral) : decimal.subtract(integral);
        fractional = fractional.movePointRight(decimal.scale());
        StringBuilder sb = new StringBuilder(fractional.toBigInteger().toString());
        sb = sb.reverse();
        int length = sb.length();
        int i = 0;
        while (i < decimal.scale() - length) {
            sb.append('0');
            ++i;
        }
        this.encodeUnsignedBigInteger(new BigInteger(sb.toString()));
    }

    public void encodeDecimal(boolean negative, BigInteger integral, BigInteger reverseFraction) throws IOException, RuntimeException {
        this.encodeBoolean(negative);
        this.encodeUnsignedBigInteger(integral);
        this.encodeUnsignedBigInteger(reverseFraction);
    }

    public void encodeFloat(float f) throws IOException {
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            if (Float.isNaN(f)) {
                this.encodeInteger(0);
            } else if (f < 0.0f) {
                this.encodeInteger(-1);
            } else {
                this.encodeInteger(1);
            }
            this.encodeInteger(-16384);
        } else {
            int exponent = 0;
            while (f - (float)((int)f) != 0.0f) {
                f *= 10.0f;
                --exponent;
            }
            int mantissa = (int)f;
            this.encodeFloat(mantissa, exponent);
        }
    }

    public void encodeFloat(int mantissa, int exponent) throws IOException {
        this.encodeInteger(mantissa);
        this.encodeInteger(exponent);
    }

    public void encodeDouble(double d) throws IOException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            if (Double.isNaN(d)) {
                this.encodeLong(0L);
            } else if (d < 0.0) {
                this.encodeLong(-1L);
            } else {
                this.encodeLong(1L);
            }
            this.encodeLong(-16384L);
        } else {
            long exponent = 0L;
            while (d - (double)((long)d) != 0.0) {
                d *= 10.0;
                --exponent;
            }
            long mantissa = (long)d;
            this.encodeDouble(mantissa, exponent);
        }
    }

    public void encodeDouble(long mantissa, long exponent) throws IOException {
        this.encodeLong(mantissa);
        this.encodeLong(exponent);
    }

    public void encodeDateTime(Calendar cal, DatetimeType type) throws IOException {
        switch (type) {
            case gYear: 
            case gYearMonth: 
            case date: {
                this.encodeInteger(cal.get(1) - 2000);
                this.encodeNBitUnsignedInteger(XSDDatetime.getMonthDay(cal), 9);
                this.encodeDateTimeTimezone(XSDDatetime.getTimeZoneInMinutesOffset(cal));
                break;
            }
            case dateTime: {
                this.encodeInteger(cal.get(1) - 2000);
                this.encodeNBitUnsignedInteger(XSDDatetime.getMonthDay(cal), 9);
                this.encodeNBitUnsignedInteger(XSDDatetime.getTime(cal), 17);
                this.encodeDateTimeFractionalSecs(XSDDatetime.getFractionalSecondsReverse(cal.get(14)));
                this.encodeDateTimeTimezone(XSDDatetime.getTimeZoneInMinutesOffset(cal));
                break;
            }
            case gMonth: 
            case gMonthDay: 
            case gDay: {
                this.encodeNBitUnsignedInteger(XSDDatetime.getMonthDay(cal), 9);
                this.encodeDateTimeTimezone(XSDDatetime.getTimeZoneInMinutesOffset(cal));
                break;
            }
            case time: {
                this.encodeNBitUnsignedInteger(XSDDatetime.getTime(cal), 17);
                this.encodeDateTimeFractionalSecs(XSDDatetime.getFractionalSecondsReverse(cal.get(14)));
                this.encodeDateTimeTimezone(XSDDatetime.getTimeZoneInMinutesOffset(cal));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void encodeDateTime(XSDDatetime datetime) throws IOException {
        switch (datetime.getDatetimeType()) {
            case gYear: {
                this.encodeInteger(datetime.iYear);
                this.encodeDateTimeTimezone(datetime.iTZMinutes);
                break;
            }
            case gYearMonth: 
            case date: {
                this.encodeInteger(datetime.iYear);
                this.encodeNBitUnsignedInteger(datetime.iMonthDay, 9);
                this.encodeDateTimeTimezone(datetime.iTZMinutes);
                break;
            }
            case dateTime: {
                this.encodeInteger(datetime.iYear);
                this.encodeNBitUnsignedInteger(datetime.iMonthDay, 9);
                this.encodeNBitUnsignedInteger(datetime.iTime, 17);
                this.encodeDateTimeFractionalSecs(datetime.iFractionalSecs);
                this.encodeDateTimeTimezone(datetime.iTZMinutes);
                break;
            }
            case gMonth: 
            case gMonthDay: 
            case gDay: {
                this.encodeNBitUnsignedInteger(datetime.iMonthDay, 9);
                this.encodeDateTimeTimezone(datetime.iTZMinutes);
                break;
            }
            case time: {
                this.encodeNBitUnsignedInteger(datetime.iTime, 17);
                this.encodeDateTimeFractionalSecs(datetime.iFractionalSecs);
                this.encodeDateTimeTimezone(datetime.iTZMinutes);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void encodeDateTimeTimezone(int tzMinutes) throws IOException {
        if (tzMinutes != 0) {
            this.encodeBoolean(true);
            this.encodeNBitUnsignedInteger(tzMinutes, 11);
        } else {
            this.encodeBoolean(false);
        }
    }

    private void encodeDateTimeFractionalSecs(int reverseFracSecs) throws IOException {
        if (reverseFracSecs != 0) {
            this.encodeBoolean(true);
            this.encodeUnsignedInteger(reverseFracSecs);
        } else {
            this.encodeBoolean(false);
        }
    }
}

