/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.strings;

import com.siemens.ct.exi.core.container.ValueContainer;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class StringEncoderImpl
implements StringEncoder {
    protected Map<String, ValueContainer> stringValues = new HashMap<String, ValueContainer>();
    protected Map<QName, Integer> localValueSize = new HashMap<QName, Integer>();

    public void writeValue(QName context, EncoderChannel valueChannel, String value) throws IOException {
        ValueContainer vc = this.stringValues.get(value);
        if (vc != null) {
            if (vc.context == context) {
                valueChannel.encodeUnsignedInteger(0);
                int n = MethodsBag.getCodingLength(this.localValueSize.get(context));
                valueChannel.encodeNBitUnsignedInteger(vc.localValueID, n);
            } else {
                valueChannel.encodeUnsignedInteger(1);
                int n = MethodsBag.getCodingLength(this.stringValues.size());
                valueChannel.encodeNBitUnsignedInteger(vc.globalValueID, n);
            }
        } else {
            valueChannel.encodeUnsignedInteger(value.length() + 2);
            valueChannel.encodeStringOnly(value);
            this.addValue(context, value);
        }
    }

    public boolean isStringHit(QName context, String value) throws IOException {
        return this.stringValues.get(value) != null;
    }

    public void addValue(QName context, String value) {
        assert (!this.stringValues.containsKey(value));
        int globalID = this.stringValues.size();
        Integer cnt = this.localValueSize.get(context);
        if (cnt == null) {
            cnt = 0;
        }
        this.localValueSize.put(context, cnt + 1);
        ValueContainer vc = new ValueContainer(context, cnt, globalID);
        this.stringValues.put(value, vc);
    }

    public void clear() {
        this.stringValues.clear();
        this.localValueSize.clear();
    }
}

