/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.sax;

import com.siemens.ct.exi.EXIEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.api.sax.EXIWriter;
import com.siemens.ct.exi.attributes.AttributeFactory;
import com.siemens.ct.exi.attributes.AttributeList;
import com.siemens.ct.exi.core.sax.AbstractCharactersEncoder;
import com.siemens.ct.exi.core.sax.CharactersEncoderWhitespaceAware;
import com.siemens.ct.exi.core.sax.CharactersEncoderWhitespaceLess;
import com.siemens.ct.exi.exceptions.EXIException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class SAXEncoder
extends DefaultHandler2
implements EXIWriter {
    protected EXIEncoder encoder;
    protected StringBuilder sbChars;
    protected AbstractCharactersEncoder charEncoder;
    protected AttributeList exiAttributes;
    protected List<PrefixMapping> prefixMappings;

    public SAXEncoder(EXIFactory factory) {
        this.encoder = factory.createEXIEncoder();
        this.sbChars = new StringBuilder();
        this.charEncoder = factory.getFidelityOptions().isFidelityEnabled("PRESERVE_WHITESPACES") ? new CharactersEncoderWhitespaceAware(this.encoder, this.sbChars) : new CharactersEncoderWhitespaceLess(this.encoder, this.sbChars);
        this.prefixMappings = new ArrayList<PrefixMapping>();
        AttributeFactory attFactory = AttributeFactory.newInstance();
        this.exiAttributes = attFactory.createAttributeListInstance(factory);
    }

    public void setOutput(OutputStream os, boolean exiBodyOnly) throws EXIException {
        this.encoder.setOutput(os, exiBodyOnly);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMappings.add(new PrefixMapping(prefix, uri));
    }

    public void startElement(String uri, String local, String raw, Attributes attributes) throws SAXException {
        try {
            this.startElementPfx(uri, local, null, attributes);
        }
        catch (Exception e) {
            throw new SAXException("startElement: " + raw, e);
        }
    }

    protected void startElementPfx(String uri, String local, String prefix, Attributes attributes) throws EXIException, IOException {
        this.charEncoder.checkPendingChars();
        this.encoder.encodeStartElement(uri, local, prefix);
        this.handleNamespaceDeclarations();
        if (attributes != null && attributes.getLength() > 0) {
            this.handleAttributes(attributes);
        }
    }

    protected void handleNamespaceDeclarations() throws EXIException, IOException {
        int size = this.prefixMappings.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                PrefixMapping pm = this.prefixMappings.get(i);
                this.encoder.encodeNamespaceDeclaration(pm.uri, pm.prefix);
                ++i;
            }
            this.prefixMappings.clear();
        }
    }

    protected void handleAttributes(Attributes attributes) throws EXIException, IOException {
        this.exiAttributes.parse(attributes);
        if (this.exiAttributes.hasXsiType()) {
            this.encoder.encodeXsiType(this.exiAttributes.getXsiTypeRaw());
        }
        if (this.exiAttributes.hasXsiNil()) {
            this.encoder.encodeXsiNil(this.exiAttributes.getXsiNil(), this.exiAttributes.getXsiNilPrefix());
        }
        int i = 0;
        while (i < this.exiAttributes.getNumberOfAttributes()) {
            this.encoder.encodeAttribute(this.exiAttributes.getAttributeURI(i), this.exiAttributes.getAttributeLocalName(i), this.exiAttributes.getAttributePrefix(i), this.exiAttributes.getAttributeValue(i));
            ++i;
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.encoder.encodeStartDocument();
        }
        catch (Exception e) {
            throw new SAXException("startDocument", e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.charEncoder.checkPendingChars();
            this.encoder.encodeEndDocument();
        }
        catch (Exception e) {
            throw new SAXException("endDocument", e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.charEncoder.checkPendingChars();
            this.encoder.encodeProcessingInstruction(target, data);
        }
        catch (Exception e) {
            throw new SAXException("processingInstruction", e);
        }
    }

    public void endElement(String uri, String local, String raw) throws SAXException {
        try {
            this.charEncoder.checkPendingChars();
            this.encoder.encodeEndElement();
        }
        catch (Exception e) {
            throw new SAXException("endElement=" + raw, e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.sbChars.append(ch, start, length);
    }

    static final class PrefixMapping {
        final String prefix;
        final String uri;

        public PrefixMapping(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }
    }
}

