/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIEncoder;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.AbstractEXICoder;
import com.siemens.ct.exi.core.EXIHeader;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.EventInformation;
import com.siemens.ct.exi.grammar.TypeGrammar;
import com.siemens.ct.exi.grammar.event.Attribute;
import com.siemens.ct.exi.grammar.event.DatatypeEvent;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltIn;
import com.siemens.ct.exi.types.TypeEncoder;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.util.datatype.XSDBoolean;
import com.siemens.ct.exi.util.xml.QNameUtilities;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.namespace.QName;

public abstract class AbstractEXIEncoder
extends AbstractEXICoder
implements EXIEncoder {
    protected String sePrefix = null;
    protected XSDBoolean nil = XSDBoolean.newInstance();
    protected EncoderChannel channel;
    protected OutputStream os;
    protected TypeEncoder typeEncoder;

    public AbstractEXIEncoder(EXIFactory exiFactory) {
        super(exiFactory);
        this.typeEncoder = exiFactory.createTypeEncoder();
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.typeEncoder.clear();
    }

    public void setOutput(OutputStream os, boolean exiBodyOnly) throws EXIException {
        this.os = os;
        if (!exiBodyOnly) {
            EXIHeader.write(os);
        }
    }

    protected void flush() throws IOException {
        this.channel.flush();
    }

    protected void writeString(String text) throws IOException {
        this.channel.encodeString(text);
    }

    protected void writeUri(String uri) throws IOException {
        int nUri = MethodsBag.getCodingLength(this.runtimeURIEntries.size() + 1);
        this.updateURIContext(uri);
        if (this.uriContext == null) {
            this.channel.encodeNBitUnsignedInteger(0, nUri);
            this.channel.encodeString(uri);
            this.addURI(uri);
        } else {
            this.channel.encodeNBitUnsignedInteger(this.uriContext.id + 1, nUri);
        }
    }

    protected QName writeLocalName(String localName, String uri) throws IOException {
        QName qname;
        this.updateURIContext(uri);
        assert (this.uriContext != null);
        Integer localNameID = this.uriContext.getLocalNameID(localName);
        if (localNameID == null) {
            this.channel.encodeUnsignedInteger(localName.length() + 1);
            this.channel.encodeStringOnly(localName);
            qname = this.uriContext.addLocalName(localName);
        } else {
            this.channel.encodeUnsignedInteger(0);
            int n = MethodsBag.getCodingLength(this.uriContext.getLocalNameSize());
            this.channel.encodeNBitUnsignedInteger(localNameID, n);
            qname = this.uriContext.getNameContext(localNameID);
        }
        return qname;
    }

    protected void writePrefix(String prefix, String uri) throws IOException {
        Integer pfxID = this.uriContext.getPrefixID(prefix);
        int nPfx = MethodsBag.getCodingLength(this.uriContext.getPrefixSize() + 1);
        if (pfxID == null) {
            this.channel.encodeNBitUnsignedInteger(0, nPfx);
            this.channel.encodeString(prefix);
            this.uriContext.addPrefix(prefix);
        } else {
            this.channel.encodeNBitUnsignedInteger(pfxID + 1, nPfx);
        }
    }

    protected EventInformation lookForAttribute(String uri, String localName) {
        EventInformation ei = this.currentRule.lookForAttribute(uri, localName);
        if (ei == null && (ei = this.currentRule.lookForAttributeNS(uri)) == null) {
            ei = this.currentRule.lookForEvent(EventType.ATTRIBUTE_GENERIC);
        }
        return ei;
    }

    protected boolean isTypeValid(Datatype datatype, String value) {
        return this.typeEncoder.isValid(datatype, value);
    }

    protected abstract void writeValueTypeValid(QName var1) throws IOException;

    protected abstract void writeValueAsString(QName var1, String var2) throws IOException;

    protected void encode1stLevelEventCode(int pos) throws IOException {
        int codeLength = this.currentRule.get1stLevelEventCodeLength(this.fidelityOptions);
        if (codeLength > 0) {
            this.channel.encodeNBitUnsignedInteger(pos, codeLength);
        }
    }

    protected void encode2ndLevelEventCode(int pos) throws IOException {
        this.channel.encodeNBitUnsignedInteger(this.currentRule.getNumberOfEvents(), this.currentRule.get1stLevelEventCodeLength(this.fidelityOptions));
        int ch2 = this.currentRule.get2ndLevelCharacteristics(this.fidelityOptions);
        assert (pos < ch2);
        this.channel.encodeNBitUnsignedInteger(pos, MethodsBag.getCodingLength(ch2));
    }

    protected void encode3rdLevelEventCode(int pos) throws IOException {
        this.channel.encodeNBitUnsignedInteger(this.currentRule.getNumberOfEvents(), this.currentRule.get1stLevelEventCodeLength(this.fidelityOptions));
        int ch2 = this.currentRule.get2ndLevelCharacteristics(this.fidelityOptions);
        int ec2 = ch2 > 0 ? ch2 - 1 : 0;
        this.channel.encodeNBitUnsignedInteger(ec2, MethodsBag.getCodingLength(ch2));
        int ch3 = this.currentRule.get3rdLevelCharacteristics(this.fidelityOptions);
        assert (pos < ch3);
        this.channel.encodeNBitUnsignedInteger(pos, MethodsBag.getCodingLength(ch3));
    }

    protected QName encodeQName(String uri, String localName) throws IOException {
        this.writeUri(uri);
        return this.writeLocalName(localName, uri);
    }

    protected void encodeQNamePrefix(String uri, String prefix) throws IOException {
        if (this.preservePrefix && !uri.equals("")) {
            this.updateURIContext(uri);
            List<String> prefixes = this.uriContext.prefixes;
            int numberOfPrefixes = prefixes.size();
            if (numberOfPrefixes > 1) {
                int id = -1;
                int i = 0;
                while (i < numberOfPrefixes) {
                    if (prefixes.get(i).equals(prefix)) {
                        id = i;
                        i = numberOfPrefixes;
                    }
                    ++i;
                }
                if (id == -1) {
                    id = 0;
                }
                this.channel.encodeNBitUnsignedInteger(id, MethodsBag.getCodingLength(numberOfPrefixes));
            }
        }
    }

    public void encodeStartDocument() throws EXIException, IOException {
        if (this.os == null) {
            throw new EXIException("No valid EXI OutputStream set for encoding. Please use setOutput( ... )");
        }
        this.initForEachRun();
        EventInformation ei = this.currentRule.lookForEvent(EventType.START_DOCUMENT);
        if (ei == null) {
            throw new EXIException("No EXI Event found for startDocument");
        }
        this.currentRule = ei.next;
    }

    public void encodeEndDocument() throws EXIException, IOException {
        EventInformation ei = this.currentRule.lookForEvent(EventType.END_DOCUMENT);
        if (ei == null) {
            throw new EXIException("No EXI Event found for endDocument");
        }
        this.encode1stLevelEventCode(ei.getEventCode());
        this.flush();
    }

    public void encodeStartElement(String uri, String localName, String prefix) throws EXIException, IOException {
        StartElement nextSE;
        Rule nextTopRule;
        this.sePrefix = prefix;
        EventInformation ei = this.currentRule.lookForStartElement(uri, localName);
        if (ei != null) {
            assert (ei.event.isEventType(EventType.START_ELEMENT));
            this.encode1stLevelEventCode(ei.getEventCode());
            nextTopRule = ei.next;
            nextSE = (StartElement)ei.event;
        } else {
            ei = this.currentRule.lookForStartElementNS(uri);
            if (ei != null) {
                assert (ei.event.isEventType(EventType.START_ELEMENT_NS));
                this.encode1stLevelEventCode(ei.getEventCode());
                QName qname = this.writeLocalName(localName, uri);
                nextTopRule = ei.next;
                nextSE = this.getGenericStartElement(qname);
            } else {
                ei = this.currentRule.lookForEvent(EventType.START_ELEMENT_GENERIC);
                if (ei != null) {
                    assert (ei.event.isEventType(EventType.START_ELEMENT_GENERIC));
                    this.encode1stLevelEventCode(ei.getEventCode());
                    nextTopRule = ei.next;
                } else {
                    int ecSEundeclared = this.currentRule.get2ndLevelEventCode(EventType.START_ELEMENT_GENERIC_UNDECLARED, this.fidelityOptions);
                    if (ecSEundeclared == -1) {
                        throw new EXIException("Unexpected SE {" + uri + "}" + localName + ", " + this.exiFactory.toString());
                    }
                    this.encode2ndLevelEventCode(ecSEundeclared);
                    nextTopRule = this.currentRule.getElementContentRule();
                }
                QName qname = this.encodeQName(uri, localName);
                nextSE = this.getGenericStartElement(qname);
                this.currentRule.learnStartElement(nextSE);
            }
        }
        this.encodeQNamePrefix(uri, prefix);
        this.pushElement(nextSE, nextTopRule);
    }

    public void encodeNamespaceDeclaration(String uri, String prefix) throws EXIException, IOException {
        this.namespaces.declarePrefix(prefix, uri);
        if (this.preservePrefix) {
            assert (this.sePrefix != null);
            int ec2 = this.currentRule.get2ndLevelEventCode(EventType.NAMESPACE_DECLARATION, this.fidelityOptions);
            assert (this.currentRule.get2ndLevelEvent(ec2, this.fidelityOptions) == EventType.NAMESPACE_DECLARATION);
            this.encode2ndLevelEventCode(ec2);
            this.writeUri(uri);
            this.writePrefix(prefix, uri);
            this.channel.encodeBoolean(prefix.equals(this.sePrefix));
        }
    }

    public void encodeEndElement() throws EXIException, IOException {
        EventInformation ei = this.currentRule.lookForEvent(EventType.END_ELEMENT);
        if (ei != null) {
            this.encode1stLevelEventCode(ei.getEventCode());
        } else {
            if (this.currentRule.lookForEvent(EventType.CHARACTERS) != null) {
                this.encodeCharacters("");
                ei = this.currentRule.lookForEvent(EventType.END_ELEMENT);
            }
            if (ei != null) {
                this.encode1stLevelEventCode(ei.getEventCode());
            } else {
                int ecEEundeclared = this.currentRule.get2ndLevelEventCode(EventType.END_ELEMENT_UNDECLARED, this.fidelityOptions);
                if (ecEEundeclared == -1) {
                    throw new EXIException("Unexpected EE {" + this.elementContext + ", " + this.exiFactory.toString());
                }
                this.encode2ndLevelEventCode(ecEEundeclared);
                this.currentRule.learnEndElement();
            }
        }
        this.popElement();
    }

    public void encodeXsiType(String raw) throws EXIException, IOException {
        int ec2 = this.currentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_XSI_TYPE, this.fidelityOptions);
        if (ec2 != -1) {
            String xsiTypeLocalName;
            assert (this.currentRule.get2ndLevelEvent(ec2, this.fidelityOptions) == EventType.ATTRIBUTE_XSI_TYPE);
            this.encode2ndLevelEventCode(ec2);
            String xsiTypePrefix = QNameUtilities.getPrefixPart(raw);
            String xsiTypeURI = this.namespaces.getURI(xsiTypePrefix);
            if (xsiTypeURI == null) {
                xsiTypeURI = "";
                xsiTypeLocalName = raw;
            } else {
                xsiTypeLocalName = QNameUtilities.getLocalPart(raw);
            }
            QName xsiQName = this.encodeQName(xsiTypeURI, xsiTypeLocalName);
            this.encodeQNamePrefix(xsiTypeURI, xsiTypePrefix);
            TypeGrammar tg = this.grammar.getTypeGrammar(xsiQName);
            if (tg != null) {
                this.currentRule = tg.getType();
            }
        } else {
            this.encodeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "", raw);
        }
    }

    public void encodeXsiNil(String value, String pfx) throws EXIException, IOException {
        if (this.currentRule.isSchemaInformed()) {
            SchemaInformedRule siCurrentRule = (SchemaInformedRule)this.currentRule;
            if (this.nil.parse(value)) {
                int ec2 = siCurrentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_XSI_NIL, this.fidelityOptions);
                if (ec2 != -1) {
                    this.encode2ndLevelEventCode(ec2);
                    this.encodeQNamePrefix("http://www.w3.org/2001/XMLSchema-instance", pfx);
                } else {
                    ec2 = siCurrentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_GENERIC_UNDECLARED, this.fidelityOptions);
                    assert (ec2 != -1);
                    this.encode2ndLevelEventCode(ec2);
                    this.encodeQName("http://www.w3.org/2001/XMLSchema-instance", "nil");
                    this.encodeQNamePrefix("http://www.w3.org/2001/XMLSchema-instance", pfx);
                }
                this.channel.encodeBoolean(this.nil.getBoolean());
                if (this.nil.getBoolean()) {
                    this.currentRule = siCurrentRule.getTypeEmpty();
                }
            } else {
                this.encodeAttributeAnySchemaInvalid("http://www.w3.org/2001/XMLSchema-instance", "nil", pfx, value);
            }
        } else {
            this.encodeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", pfx, value);
        }
    }

    public void encodeAttribute(String uri, String localName, String prefix, String value) throws EXIException, IOException {
        EventInformation ei = this.lookForAttribute(uri, localName);
        if (ei != null) {
            QName atContext;
            Datatype datatype;
            EventType eventType = ei.event.getEventType();
            if (eventType == EventType.ATTRIBUTE) {
                Attribute at = (Attribute)ei.event;
                datatype = at.getDatatype();
                atContext = at.getQName();
            } else {
                assert (eventType == EventType.ATTRIBUTE_NS || eventType == EventType.ATTRIBUTE_GENERIC);
                Attribute globalAT = this.grammar.getGlobalAttribute(new QName(uri, localName));
                datatype = globalAT == null ? BuiltIn.DEFAULT_DATATYPE : globalAT.getDatatype();
                atContext = null;
            }
            boolean valid = false;
            if (this.isTypeValid(datatype, value)) {
                valid = true;
                this.encode1stLevelEventCode(ei.getEventCode());
            } else {
                int ec2ATdeviated = this.currentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_INVALID_VALUE, this.fidelityOptions);
                this.encode2ndLevelEventCode(ec2ATdeviated);
                int eventCode3 = ei.getEventCode() - this.currentRule.getLeastAttributeEventCode();
                this.channel.encodeNBitUnsignedInteger(eventCode3, MethodsBag.getCodingLength(this.currentRule.getNumberOfSchemaDeviatedAttributes()));
            }
            if (eventType != EventType.ATTRIBUTE) {
                if (eventType == EventType.ATTRIBUTE_NS) {
                    atContext = this.writeLocalName(localName, uri);
                } else {
                    assert (eventType == EventType.ATTRIBUTE_GENERIC);
                    atContext = this.encodeQName(uri, localName);
                }
            }
            this.encodeQNamePrefix(uri, prefix);
            if (valid) {
                this.writeValueTypeValid(atContext);
            } else {
                this.writeValueAsString(atContext, value);
            }
            this.currentRule = ei.next;
        } else {
            int ecATundeclared = this.currentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_GENERIC_UNDECLARED, this.fidelityOptions);
            if (ecATundeclared != -1) {
                this.encode2ndLevelEventCode(ecATundeclared);
                QName atQName = this.encodeQName(uri, localName);
                this.encodeQNamePrefix(uri, prefix);
                this.writeValueAsString(atQName, value);
                this.currentRule.learnAttribute(new Attribute(atQName));
            } else {
                assert (this.fidelityOptions.isStrict());
                this.throwWarning("Skip AT " + localName);
            }
        }
    }

    protected void encodeAttributeAnySchemaInvalid(String uri, String localName, String prefix, String value) throws IOException {
        if (this.fidelityOptions.isStrict()) {
            this.throwWarning("Prune AT" + localName);
        } else {
            int ec2ATdeviated = this.currentRule.get2ndLevelEventCode(EventType.ATTRIBUTE_INVALID_VALUE, this.fidelityOptions);
            this.encode2ndLevelEventCode(ec2ATdeviated);
            int eventCode3 = this.currentRule.getNumberOfSchemaDeviatedAttributes() - 1;
            this.channel.encodeNBitUnsignedInteger(eventCode3, MethodsBag.getCodingLength(this.currentRule.getNumberOfSchemaDeviatedAttributes()));
            QName atQname = this.encodeQName(uri, localName);
            this.encodeQNamePrefix(uri, prefix);
            this.writeValueAsString(atQname, value);
        }
    }

    public void encodeCharacters(String chars) throws EXIException, IOException {
        EventInformation ei = this.currentRule.lookForEvent(EventType.CHARACTERS);
        if (ei != null && this.isTypeValid(((DatatypeEvent)ei.event).getDatatype(), chars)) {
            this.encode1stLevelEventCode(ei.getEventCode());
            this.writeValueTypeValid(this.elementContext.qname);
            this.currentRule = ei.next;
        } else {
            ei = this.currentRule.lookForEvent(EventType.CHARACTERS_GENERIC);
            if (ei != null) {
                this.encode1stLevelEventCode(ei.getEventCode());
                this.currentRule = ei.next;
                this.writeValueAsString(this.elementContext.qname, chars);
            } else {
                int ecCHundeclared = this.currentRule.get2ndLevelEventCode(EventType.CHARACTERS_GENERIC_UNDECLARED, this.fidelityOptions);
                if (ecCHundeclared == -1) {
                    this.throwWarning("Skip CH: '" + chars + "'");
                } else {
                    this.encode2ndLevelEventCode(ecCHundeclared);
                    this.currentRule.learnCharacters();
                    this.writeValueAsString(this.elementContext.qname, chars);
                    this.currentRule = this.currentRule.getElementContentRule();
                }
            }
        }
    }

    public void encodeDocType(String name, String publicID, String systemID, String text) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            int ec2 = this.currentRule.get2ndLevelEventCode(EventType.DOC_TYPE, this.fidelityOptions);
            this.encode2ndLevelEventCode(ec2);
            this.writeString(name);
            this.writeString(publicID);
            this.writeString(systemID);
            this.writeString(text);
        }
    }

    public void encodeEntityReference(String name) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            int ec2 = this.currentRule.get2ndLevelEventCode(EventType.ENTITY_REFERENCE, this.fidelityOptions);
            this.encode2ndLevelEventCode(ec2);
            this.writeString(name);
        }
    }

    public void encodeComment(char[] ch, int start, int length) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS")) {
            int ec3 = this.currentRule.get3rdLevelEventCode(EventType.COMMENT, this.fidelityOptions);
            this.encode3rdLevelEventCode(ec3);
            this.writeString(new String(ch, start, length));
            this.currentRule = this.currentRule.getElementContentRule();
        }
    }

    public void encodeProcessingInstruction(String target, String data) throws EXIException, IOException {
        if (this.fidelityOptions.isFidelityEnabled("PRESERVE_PIS")) {
            int ec3 = this.currentRule.get3rdLevelEventCode(EventType.PROCESSING_INSTRUCTION, this.fidelityOptions);
            this.encode3rdLevelEventCode(ec3);
            this.writeString(target);
            this.writeString(data);
            this.currentRule = this.currentRule.getElementContentRule();
        }
    }
}

