/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi;

import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.Grammar;
import com.siemens.ct.exi.grammar.SchemaLessGrammar;
import com.siemens.ct.exi.grammar.XSDGrammarBuilder;
import java.io.InputStream;

public class GrammarFactory {
    private static XSDGrammarBuilder grammarBuilder = XSDGrammarBuilder.newInstance();

    protected GrammarFactory() {
    }

    public static GrammarFactory newInstance() {
        return new GrammarFactory();
    }

    public Grammar createGrammar(String xsdLocation) throws EXIException {
        if (xsdLocation == null || xsdLocation.equals("")) {
            throw new EXIException("SchemaLocation not specified correctly!");
        }
        grammarBuilder.loadGrammar(xsdLocation);
        return grammarBuilder.toGrammar();
    }

    public Grammar createGrammar(InputStream is) throws EXIException {
        grammarBuilder.loadGrammar(is);
        return grammarBuilder.toGrammar();
    }

    public Grammar createSchemaLessGrammar() {
        return new SchemaLessGrammar();
    }
}

