/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.RestrictedCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.StringValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class RestrictedCharacterSetDatatype
extends AbstractDatatype {
    protected String lastValidValue;

    public RestrictedCharacterSetDatatype(QName datatypeIdentifier, RestrictedCharacterSet rcs) {
        this(datatypeIdentifier);
        this.rcs = rcs;
    }

    public RestrictedCharacterSetDatatype(QName datatypeIdentifier) {
        super(BuiltInType.RESTRICTED_CHARACTER_SET, datatypeIdentifier);
    }

    public void setRestrictedCharacterSet(RestrictedCharacterSet rcs) {
        this.rcs = rcs;
    }

    public RestrictedCharacterSet getRestrictedCharacterSet() {
        return this.rcs;
    }

    public boolean isValid(String value) {
        this.lastValidValue = value;
        return true;
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        if (stringEncoder.isStringHit(context, this.lastValidValue)) {
            stringEncoder.writeValue(context, valueChannel, this.lastValidValue);
        } else {
            int numberOfTuples = this.lastValidValue.length();
            valueChannel.encodeUnsignedInteger(numberOfTuples + 2);
            int numberOfBits = this.rcs.getCodingLength();
            int i = 0;
            while (i < numberOfTuples) {
                int codePoint = this.lastValidValue.codePointAt(i);
                int code = this.rcs.getCode(codePoint);
                if (code == -1) {
                    valueChannel.encodeNBitUnsignedInteger(this.rcs.size(), numberOfBits);
                    valueChannel.encodeUnsignedInteger(codePoint);
                } else {
                    valueChannel.encodeNBitUnsignedInteger(code, numberOfBits);
                }
                ++i;
            }
            stringEncoder.addValue(context, this.lastValidValue);
        }
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        Value value;
        int i = valueChannel.decodeUnsignedInteger();
        if (i == 0) {
            value = stringDecoder.readValueLocalHit(context, valueChannel);
        } else if (i == 1) {
            value = stringDecoder.readValueGlobalHit(context, valueChannel);
        } else {
            int slen = i - 2;
            int numberOfBits = this.rcs.getCodingLength();
            int size = this.rcs.size();
            value = new StringValue(new char[slen]);
            char[] cValue = value.toCharacters();
            int k = 0;
            while (k < slen) {
                int code = valueChannel.decodeNBitUnsignedInteger(numberOfBits);
                int codePoint = code == size ? valueChannel.decodeUnsignedInteger() : this.rcs.getCodePoint(code);
                Character.toChars(codePoint, cValue, k);
                ++k;
            }
            stringDecoder.addValue(context, value);
        }
        return value;
    }
}

