/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.helpers;

import com.siemens.ct.exi.datatype.RestrictedCharacterSet;
import com.siemens.ct.exi.exceptions.UnknownElementException;
import com.siemens.ct.exi.util.MethodsBag;
import java.util.HashMap;
import java.util.Map;

public class BuiltInRestrictedCharacterSets
implements RestrictedCharacterSet {
    protected Map<Character, Integer> codeSet = new HashMap<Character, Integer>();
    protected Map<Integer, Character> characterSet = new HashMap<Integer, Character>();
    protected int size;
    protected int codingLength;

    protected BuiltInRestrictedCharacterSets() {
    }

    public static RestrictedCharacterSet newXSDBase64BinaryInstance() {
        BuiltInRestrictedCharacterSets rcs = new BuiltInRestrictedCharacterSets();
        rcs.addValue('\t');
        rcs.addValue('\n');
        rcs.addValue('\r');
        rcs.addValue(' ');
        rcs.addValue('+');
        rcs.addValue('/');
        int i = 48;
        while (i <= 57) {
            rcs.addValue((char)i);
            ++i;
        }
        rcs.addValue('=');
        i = 65;
        while (i <= 90) {
            rcs.addValue((char)i);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            rcs.addValue((char)i);
            ++i;
        }
        return rcs;
    }

    public static RestrictedCharacterSet newXSDHexBinaryInstance() {
        BuiltInRestrictedCharacterSets rcs = new BuiltInRestrictedCharacterSets();
        rcs.addValue('\t');
        rcs.addValue('\n');
        rcs.addValue('\r');
        rcs.addValue(' ');
        int i = 48;
        while (i <= 57) {
            rcs.addValue((char)i);
            ++i;
        }
        i = 65;
        while (i <= 70) {
            rcs.addValue((char)i);
            ++i;
        }
        i = 97;
        while (i <= 102) {
            rcs.addValue((char)i);
            ++i;
        }
        return rcs;
    }

    public static RestrictedCharacterSet newXSDBooleanInstance() {
        BuiltInRestrictedCharacterSets rcs = new BuiltInRestrictedCharacterSets();
        rcs.addValue('\t');
        rcs.addValue('\n');
        rcs.addValue('\r');
        rcs.addValue(' ');
        rcs.addValue('0');
        rcs.addValue('1');
        rcs.addValue('a');
        rcs.addValue('e');
        rcs.addValue('f');
        rcs.addValue('l');
        rcs.addValue('r');
        rcs.addValue('s');
        rcs.addValue('t');
        rcs.addValue('u');
        return rcs;
    }

    public static RestrictedCharacterSet newXSDDateTimeInstance() {
        BuiltInRestrictedCharacterSets rcs = new BuiltInRestrictedCharacterSets();
        rcs.addValue('\t');
        rcs.addValue('\n');
        rcs.addValue('\r');
        rcs.addValue(' ');
        rcs.addValue('+');
        rcs.addValue('-');
        rcs.addValue('.');
        int i = 48;
        while (i <= 57) {
            rcs.addValue((char)i);
            ++i;
        }
        rcs.addValue(':');
        rcs.addValue('T');
        rcs.addValue('Z');
        return rcs;
    }

    public static RestrictedCharacterSet newXSDDecimalInstance() {
        BuiltInRestrictedCharacterSets rcs = new BuiltInRestrictedCharacterSets();
        rcs.addValue('\t');
        rcs.addValue('\n');
        rcs.addValue('\r');
        rcs.addValue(' ');
        rcs.addValue('+');
        rcs.addValue('-');
        rcs.addValue('.');
        int i = 48;
        while (i <= 57) {
            rcs.addValue((char)i);
            ++i;
        }
        return rcs;
    }

    public static RestrictedCharacterSet newXSDDoubleInstance() {
        BuiltInRestrictedCharacterSets rcs = new BuiltInRestrictedCharacterSets();
        rcs.addValue('\t');
        rcs.addValue('\n');
        rcs.addValue('\r');
        rcs.addValue(' ');
        rcs.addValue('+');
        rcs.addValue('-');
        rcs.addValue('.');
        int i = 48;
        while (i <= 57) {
            rcs.addValue((char)i);
            ++i;
        }
        rcs.addValue('E');
        rcs.addValue('F');
        rcs.addValue('I');
        rcs.addValue('N');
        rcs.addValue('a');
        rcs.addValue('e');
        return rcs;
    }

    public static RestrictedCharacterSet newXSDIntegerInstance() {
        BuiltInRestrictedCharacterSets rcs = new BuiltInRestrictedCharacterSets();
        rcs.addValue('\t');
        rcs.addValue('\n');
        rcs.addValue('\r');
        rcs.addValue(' ');
        rcs.addValue('+');
        rcs.addValue('-');
        int i = 48;
        while (i <= 57) {
            rcs.addValue((char)i);
            ++i;
        }
        return rcs;
    }

    public char getCharacter(int code) throws UnknownElementException {
        Character character = this.characterSet.get(code);
        if (character == null) {
            throw new UnknownElementException("Unknown RestrictedCharacterSet code: " + code);
        }
        return character.charValue();
    }

    public int getCode(char c) {
        Integer code = this.codeSet.get(Character.valueOf(c));
        return code == null ? -1 : code;
    }

    public int size() {
        return this.size;
    }

    public int getCodingLength() {
        return this.codingLength;
    }

    protected void addValue(char c) {
        this.codeSet.put(Character.valueOf(c), this.codeSet.size());
        this.characterSet.put(this.characterSet.size(), Character.valueOf(c));
        assert (this.codeSet.size() == this.characterSet.size());
        this.size = this.codeSet.size();
        this.codingLength = MethodsBag.getCodingLength(this.size + 1);
    }
}

