/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammar.rule;

import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.grammar.event.Event;
import com.siemens.ct.exi.grammar.rule.AbstractRule;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaLessRule;
import com.siemens.ct.exi.util.MethodsBag;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSchemaLessRule
extends AbstractRule
implements SchemaLessRule {
    protected List<Event> events;
    protected List<Rule> rules;

    public AbstractSchemaLessRule() {
        this.init();
    }

    private void init() {
        this.events = new ArrayList<Event>();
        this.rules = new ArrayList<Rule>();
    }

    public final boolean isSchemaRule() {
        return false;
    }

    protected int getInternalIndex(int eventCode) {
        return this.getNumberOfEvents() - 1 - eventCode;
    }

    protected int getEventCode(int internalIndex) {
        return this.getNumberOfEvents() - 1 - internalIndex;
    }

    public int get1stLevelEventCodeLength(FidelityOptions fidelityOptions) {
        return this.hasSecondOrThirdLevel(fidelityOptions) ? MethodsBag.getCodingLength(this.events.size() + 1) : MethodsBag.getCodingLength(this.events.size());
    }

    public int get1stLevelEventCode(Event event) {
        int i = 0;
        while (i < this.events.size()) {
            if (this.events.get(i).equals(event)) {
                return this.getEventCode(i);
            }
            ++i;
        }
        return -1;
    }

    public Event get1stLevelEvent(int eventCode) {
        return this.events.get(this.getInternalIndex(eventCode));
    }

    public int getNumberOfEvents() {
        assert (this.events.size() == this.rules.size());
        return this.events.size();
    }

    public void addRule(Event event, Rule rule) {
        assert (!this.isTerminalRule());
        assert (!this.contains(event));
        this.events.add(event);
        this.rules.add(rule);
    }

    public Rule get1stLevelRule(int ec) throws IndexOutOfBoundsException {
        return this.rules.get(this.getInternalIndex(ec));
    }

    protected boolean contains(Event event) {
        int i = 0;
        while (i < this.events.size()) {
            if (this.events.get(i).equals(event)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        String s = String.valueOf(this.getLabel()) + "//" + "\t";
        if (this.isTerminalRule()) {
            s = String.valueOf(s) + "<END_RULE>";
        } else {
            s = String.valueOf(s) + "[";
            int ec = 0;
            while (ec < this.getNumberOfEvents()) {
                s = String.valueOf(s) + "," + this.get1stLevelEvent(ec);
                ++ec;
            }
            s = String.valueOf(s) + "]";
        }
        return s;
    }
}

