/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammar.rule;

import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.grammar.EventRule;
import com.siemens.ct.exi.grammar.event.Event;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.rule.AbstractRule;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import com.siemens.ct.exi.util.MethodsBag;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaInformedRule
extends AbstractRule
implements SchemaInformedRule {
    protected List<EventRule> eventRules;
    protected int numberOfEvents;
    protected int codeLengthA;
    protected int codeLengthB;
    protected boolean lambdasResolved = false;
    protected boolean hasNamedSubtypes = false;
    protected boolean isNillable = false;
    protected SchemaInformedRule typeEmpty;
    protected boolean isFirstElementRule = false;
    protected int leastAttributeEventCode = -1;
    protected int numberDeviatedAttributes = 0;
    protected List<SchemaInformedRule> lambdaTransitions;

    public AbstractSchemaInformedRule() {
        this.init();
    }

    public AbstractSchemaInformedRule(String label) {
        super(label);
        this.init();
    }

    private void init() {
        this.eventRules = new ArrayList<EventRule>();
        this.lambdaTransitions = new ArrayList<SchemaInformedRule>();
    }

    @Override
    public final boolean isSchemaRule() {
        return true;
    }

    @Override
    public int get1stLevelEventCodeLength(FidelityOptions fidelityOptions) {
        return this.hasSecondOrThirdLevel(fidelityOptions) ? this.codeLengthB : this.codeLengthA;
    }

    @Override
    public int get1stLevelEventCode(Event event) {
        int ec = 0;
        for (EventRule er : this.eventRules) {
            if (er.getEvent().equals(event)) {
                return ec;
            }
            ++ec;
        }
        return -1;
    }

    @Override
    public Event get1stLevelEvent(int eventCode) {
        return this.eventRules.get(eventCode).getEvent();
    }

    @Override
    public void setHasNamedSubtypes(boolean hasNamedSubtypes) {
        this.hasNamedSubtypes = hasNamedSubtypes;
    }

    @Override
    public void setNillable(boolean nil, SchemaInformedRule typeEmpty) {
        this.isNillable = nil;
        this.typeEmpty = typeEmpty;
    }

    @Override
    public SchemaInformedRule getTypeEmpty() {
        return this.typeEmpty;
    }

    @Override
    public void setFirstElementRule() {
        this.isFirstElementRule = true;
    }

    @Override
    public int getNumberOfSchemaDeviatedAttributes() {
        return this.numberDeviatedAttributes;
    }

    @Override
    public int getLeastAttributeEventCode() {
        return this.leastAttributeEventCode;
    }

    @Override
    public void resolveLambdaTransitions() {
        this.resolveLambdaTransitions(new ArrayList<EventRule>(), new ArrayList<Rule>());
    }

    protected void resolveLambdaTransitions(List<EventRule> reachableEventRules, List<Rule> alreadyHandledRules) {
        if (alreadyHandledRules.contains(this)) {
            return;
        }
        alreadyHandledRules.add(this);
        int i = 0;
        while (i < this.getNumberOfEvents()) {
            reachableEventRules.add(this.getEventRuleAt(i));
            ++i;
        }
        if (!this.lambdaTransitions.isEmpty()) {
            for (AbstractSchemaInformedRule abstractSchemaInformedRule : this.lambdaTransitions) {
                abstractSchemaInformedRule.resolveLambdaTransitions(reachableEventRules, alreadyHandledRules);
            }
        }
        if (alreadyHandledRules.get(0) == this) {
            i = 0;
            while (i < reachableEventRules.size()) {
                EventRule eventRule = reachableEventRules.get(i);
                if (!this.contains(eventRule.getEvent())) {
                    this.updateSortedEventRules(eventRule.getEvent(), eventRule.getRule());
                }
                ++i;
            }
            this.lambdaTransitions.clear();
            this.lambdasResolved = true;
            i = 0;
            while (i < this.getNumberOfEvents()) {
                AbstractSchemaInformedRule abstractSchemaInformedRule = (AbstractSchemaInformedRule)this.eventRules.get(i).getRule();
                if (!abstractSchemaInformedRule.lambdasResolved) {
                    abstractSchemaInformedRule.resolveLambdaTransitions(new ArrayList<EventRule>(), new ArrayList<Rule>());
                }
                ++i;
            }
        }
    }

    @Override
    public int getNumberOfEvents() {
        return this.numberOfEvents;
    }

    protected EventRule getEventRuleAt(int ec) throws IndexOutOfBoundsException {
        return this.eventRules.get(ec);
    }

    @Override
    public Rule get1stLevelRule(int ec) throws IndexOutOfBoundsException {
        return this.eventRules.get(ec).getRule();
    }

    protected boolean contains(Event event) {
        return this.getInternalEventId(event) != -1;
    }

    protected int getInternalEventId(Event event) {
        int id = 0;
        while (id < this.getNumberOfEvents()) {
            if (this.getEventRuleAt(id).getEvent().equals(event)) {
                return id;
            }
            ++id;
        }
        return -1;
    }

    @Override
    public void addRule(Event event, Rule rule) {
        if (this.isTerminalRule()) {
            throw new IllegalArgumentException("EndRule can not have events attached");
        }
        if (event.isEventType(EventType.LAMBDA)) {
            assert (rule instanceof SchemaInformedRule);
            this.lambdasResolved = false;
            this.lambdaTransitions.add((SchemaInformedRule)rule);
        } else if (this.contains(event)) {
            this.checkUndecidableEvent(event);
        } else {
            this.updateSortedEventRules(event, rule);
        }
    }

    protected void updateSortedEventRules(Event newEvent, Rule newRule) {
        TreeSet<EventRule> sorted = new TreeSet<EventRule>();
        int i = 0;
        while (i < this.getNumberOfEvents()) {
            EventRule curr = this.getEventRuleAt(i);
            sorted.add(curr);
            ++i;
        }
        sorted.add(new EventRule(newEvent, newRule));
        this.eventRules.clear();
        this.eventRules.addAll(sorted);
        this.numberOfEvents = this.eventRules.size();
        this.codeLengthA = MethodsBag.getCodingLength(this.numberOfEvents);
        this.codeLengthB = MethodsBag.getCodingLength(this.numberOfEvents + 1);
        this.leastAttributeEventCode = -1;
        this.numberDeviatedAttributes = 0;
        i = 0;
        while (i < this.eventRules.size()) {
            EventRule er = this.eventRules.get(i);
            if (er.getEvent().isEventType(EventType.ATTRIBUTE)) {
                if (this.leastAttributeEventCode == -1) {
                    this.leastAttributeEventCode = i;
                }
                ++this.numberDeviatedAttributes;
            }
            ++i;
        }
        ++this.numberDeviatedAttributes;
    }

    private void checkUndecidableEvent(Event event) {
        int id = this.getInternalEventId(event);
        EventRule er = this.getEventRuleAt(id);
        if (!event.equals(er.getEvent())) {
            throw new IllegalArgumentException("Illegal Duplicate Event: " + event + " for " + this);
        }
    }

    @Override
    public void joinRules(Rule rule) {
        int i = 0;
        while (i < rule.getNumberOfEvents()) {
            Event event = rule.get1stLevelEvent(i);
            Rule r = rule.get1stLevelRule(i);
            if (this.contains(event)) {
                this.checkUndecidableEvent(event);
            } else {
                this.updateSortedEventRules(event, r);
            }
            ++i;
        }
        if (rule instanceof AbstractSchemaInformedRule) {
            AbstractSchemaInformedRule siRule = (AbstractSchemaInformedRule)rule;
            if (siRule.lambdaTransitions != null && siRule.lambdaTransitions.size() > 0) {
                int i2 = 0;
                while (i2 < siRule.lambdaTransitions.size()) {
                    this.lambdaTransitions.add(siRule.lambdaTransitions.get(i2));
                    ++i2;
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SchemaInformedRule");
        sb.append('[');
        int i = 0;
        while (i < this.getNumberOfEvents()) {
            sb.append(this.get1stLevelEvent(i).toString());
            if (i < this.getNumberOfEvents() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public SchemaInformedRule duplicate() {
        return this;
    }
}

