/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammar.rule;

import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.grammar.event.EndElement;
import com.siemens.ct.exi.grammar.event.Event;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.RuleDocEnd;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRule
implements Rule {
    protected static final SchemaInformedRule END_RULE = new RuleDocEnd();
    protected static final EndElement END_ELEMENT_EVENT = new EndElement();
    private String label = null;

    public AbstractRule() {
    }

    public AbstractRule(String label) {
        this();
        this.label = label;
    }

    @Override
    public void addTerminalRule(Event event) {
        assert (event.isEventType(EventType.END_ELEMENT) || event.isEventType(EventType.END_DOCUMENT));
        this.addRule(event, END_RULE);
    }

    @Override
    public boolean isTerminalRule() {
        return this == END_RULE;
    }

    @Override
    public void learnStartElement(String uri, String localName) {
    }

    @Override
    public void learnEndElement() {
    }

    @Override
    public void learnAttribute(String uri, String localName) {
    }

    @Override
    public void learnCharacters() {
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        if (this.label != null && !this.label.equals("")) {
            return this.label;
        }
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.hashCode() + "]";
    }

    @Override
    public int get3rdLevelCharacteristics(FidelityOptions fidelityOptions) {
        int ch3 = 0;
        if (!fidelityOptions.isStrict()) {
            if (fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS")) {
                ++ch3;
            }
            if (fidelityOptions.isFidelityEnabled("PRESERVE_PIS")) {
                ++ch3;
            }
        }
        return ch3;
    }

    @Override
    public int get3rdLevelEventCode(EventType eventType, FidelityOptions fidelityOptions) {
        int ec3 = -1;
        if (!fidelityOptions.isStrict()) {
            if (fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS")) {
                if (EventType.COMMENT == eventType) {
                    ec3 = 0;
                } else if (EventType.PROCESSING_INSTRUCTION == eventType) {
                    ec3 = 1;
                }
            } else if (fidelityOptions.isFidelityEnabled("PRESERVE_PIS") && EventType.PROCESSING_INSTRUCTION == eventType) {
                ec3 = 0;
            }
        }
        return ec3;
    }

    @Override
    public EventType get3rdLevelEvent(int eventCode, FidelityOptions fidelityOptions) {
        if (eventCode == 0) {
            if (fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS")) {
                return EventType.COMMENT;
            }
            return EventType.PROCESSING_INSTRUCTION;
        }
        return EventType.PROCESSING_INSTRUCTION;
    }

    @Override
    public boolean hasSecondOrThirdLevel(FidelityOptions fidelityOptions) {
        return !fidelityOptions.isStrict();
    }

    protected static int getEventCode(EventType eventType, List<EventType> events) {
        int i = 0;
        while (i < events.size()) {
            if (events.get(i).equals((Object)eventType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Rule getElementContentRule() {
        return this;
    }

    @Override
    public Rule getElementContentRuleForUndeclaredSE() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Rule) {
            Rule r = (Rule)obj;
            int numberOfEvents = r.getNumberOfEvents();
            if (this.getNumberOfEvents() == numberOfEvents) {
                int i = 0;
                while (i < numberOfEvents) {
                    Event ev = r.get1stLevelEvent(i);
                    if (!ev.equals(this.get1stLevelEvent(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

