/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.decoder;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.datatype.AbstractTypeCoder;
import com.siemens.ct.exi.datatype.decoder.TypeDecoder;
import com.siemens.ct.exi.datatype.stringtable.StringTableDecoder;
import com.siemens.ct.exi.datatype.stringtable.StringTableDecoderImpl;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import java.io.IOException;

public abstract class AbstractTypeDecoder
extends AbstractTypeCoder
implements TypeDecoder {
    protected StringTableDecoder stringTable;

    public AbstractTypeDecoder(EXIFactory exiFactory) {
        this.stringTable = new StringTableDecoderImpl(exiFactory.getGrammar().isSchemaInformed());
    }

    public StringTableDecoder getStringTable() {
        return this.stringTable;
    }

    public void setStringTable(StringTableDecoder stringTable) {
        this.stringTable = stringTable;
    }

    public String readValueAsString(DecoderChannel dc, String namespaceURI, String localName) throws IOException {
        int i = dc.decodeUnsignedInteger();
        String value = i == 0 ? this.readStringAsLocalHit(dc, namespaceURI, localName) : (i == 1 ? this.readStringAsGlobalHit(dc) : this.readStringAsMiss(dc, namespaceURI, localName, i - 2));
        assert (value != null);
        return value;
    }

    public String readStringAsLocalHit(DecoderChannel dc, String namespaceURI, String localName) throws IOException {
        int n = MethodsBag.getCodingLength(this.stringTable.getLocalValueTableSize(namespaceURI, localName));
        int localID = dc.decodeNBitUnsignedInteger(n);
        return this.stringTable.getLocalValue(namespaceURI, localName, localID);
    }

    public String readStringAsGlobalHit(DecoderChannel dc) throws IOException {
        int n = MethodsBag.getCodingLength(this.stringTable.getGlobalValueTableSize());
        int globalID = dc.decodeNBitUnsignedInteger(n);
        return this.stringTable.getGlobalValue(globalID);
    }

    public String readStringAsMiss(DecoderChannel dc, String namespaceURI, String localName, int slen) throws IOException {
        String value = dc.decodeStringOnly(slen);
        this.stringTable.addLocalValue(namespaceURI, localName, value);
        this.stringTable.addGlobalValue(value);
        return value;
    }
}

