/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.BuiltInType;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.DatatypeBinary;
import com.siemens.ct.exi.datatype.DatatypeBoolean;
import com.siemens.ct.exi.datatype.DatatypeBooleanPattern;
import com.siemens.ct.exi.datatype.DatatypeDatetime;
import com.siemens.ct.exi.datatype.DatatypeDecimal;
import com.siemens.ct.exi.datatype.DatatypeEnumeration;
import com.siemens.ct.exi.datatype.DatatypeFloat;
import com.siemens.ct.exi.datatype.DatatypeInteger;
import com.siemens.ct.exi.datatype.DatatypeList;
import com.siemens.ct.exi.datatype.DatatypeNBitInteger;
import com.siemens.ct.exi.datatype.DatatypeString;
import com.siemens.ct.exi.datatype.DatatypeUnsignedInteger;
import com.siemens.ct.exi.exceptions.XMLParsingException;
import com.siemens.ct.exi.util.ExpandedName;
import com.siemens.ct.exi.util.datatype.DatetimeType;
import com.siemens.ct.exi.util.datatype.XSDInteger;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class BuiltIn {
    protected static final ExpandedName XSD_BASE64BINARY = new ExpandedName("http://www.w3.org/2001/XMLSchema", "base64Binary");
    protected static final ExpandedName XSD_HEXBINARY = new ExpandedName("http://www.w3.org/2001/XMLSchema", "hexBinary");
    public static final ExpandedName XSD_BOOLEAN = new ExpandedName("http://www.w3.org/2001/XMLSchema", "boolean");
    protected static final ExpandedName XSD_DATETIME = new ExpandedName("http://www.w3.org/2001/XMLSchema", "dateTime");
    protected static final ExpandedName XSD_TIME = new ExpandedName("http://www.w3.org/2001/XMLSchema", "time");
    protected static final ExpandedName XSD_DATE = new ExpandedName("http://www.w3.org/2001/XMLSchema", "date");
    protected static final ExpandedName XSD_GYEARMONTH = new ExpandedName("http://www.w3.org/2001/XMLSchema", "gYearMonth");
    protected static final ExpandedName XSD_GYEAR = new ExpandedName("http://www.w3.org/2001/XMLSchema", "gYear");
    protected static final ExpandedName XSD_GMONTHDAY = new ExpandedName("http://www.w3.org/2001/XMLSchema", "gMonthDay");
    protected static final ExpandedName XSD_GDAY = new ExpandedName("http://www.w3.org/2001/XMLSchema", "gDay");
    protected static final ExpandedName XSD_GMONTH = new ExpandedName("http://www.w3.org/2001/XMLSchema", "gMonth");
    protected static final ExpandedName XSD_DECIMAL = new ExpandedName("http://www.w3.org/2001/XMLSchema", "decimal");
    protected static final ExpandedName XSD_FLOAT = new ExpandedName("http://www.w3.org/2001/XMLSchema", "float");
    protected static final ExpandedName XSD_DOUBLE = new ExpandedName("http://www.w3.org/2001/XMLSchema", "double");
    protected static final ExpandedName XSD_INTEGER = new ExpandedName("http://www.w3.org/2001/XMLSchema", "integer");
    protected static final ExpandedName XSD_NON_NEGATIVE_INTEGER = new ExpandedName("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger");
    protected static final ExpandedName XSD_STRING = new ExpandedName("http://www.w3.org/2001/XMLSchema", "string");
    protected static final ExpandedName XSD_ANY_SIMPLE_TYPE = new ExpandedName("http://www.w3.org/2001/XMLSchema", "anySimpleType");
    public static final ExpandedName DEFAULT_VALUE_NAME = XSD_STRING;
    public static final BuiltInType DEFAULT_BUILTIN = BuiltInType.BUILTIN_STRING;
    public static final Datatype DEFAULT_DATATYPE = new DatatypeString(DEFAULT_VALUE_NAME);
    public static final Datatype BOOLEAN_DATATYPE = new DatatypeString(XSD_BOOLEAN);
    private static Map<ExpandedName, ExpandedName> datatypeMapping = new HashMap<ExpandedName, ExpandedName>();

    static {
        datatypeMapping.put(XSD_BASE64BINARY, XSD_BASE64BINARY);
        datatypeMapping.put(XSD_HEXBINARY, XSD_HEXBINARY);
        datatypeMapping.put(XSD_BOOLEAN, XSD_BOOLEAN);
        datatypeMapping.put(XSD_DATETIME, XSD_DATETIME);
        datatypeMapping.put(XSD_TIME, XSD_DATETIME);
        datatypeMapping.put(XSD_DATE, XSD_DATETIME);
        datatypeMapping.put(XSD_GYEARMONTH, XSD_DATETIME);
        datatypeMapping.put(XSD_GYEAR, XSD_DATETIME);
        datatypeMapping.put(XSD_GMONTHDAY, XSD_DATETIME);
        datatypeMapping.put(XSD_GDAY, XSD_DATETIME);
        datatypeMapping.put(XSD_GMONTH, XSD_DATETIME);
        datatypeMapping.put(XSD_DECIMAL, XSD_DECIMAL);
        datatypeMapping.put(XSD_FLOAT, XSD_DOUBLE);
        datatypeMapping.put(XSD_DOUBLE, XSD_DOUBLE);
        datatypeMapping.put(XSD_INTEGER, XSD_INTEGER);
        datatypeMapping.put(XSD_STRING, XSD_STRING);
        datatypeMapping.put(XSD_ANY_SIMPLE_TYPE, XSD_STRING);
    }

    public static Datatype getDatatype(XSSimpleTypeDefinition std) {
        Datatype datatype = null;
        if (std.getVariety() == 2) {
            XSSimpleTypeDefinition listSTD = std.getItemType();
            Datatype dtList = BuiltIn.getDatatype(listSTD);
            datatype = new DatatypeList(dtList);
        } else if (std.isDefinedFacet((short)2048)) {
            XSObjectList facetList = std.getMultiValueFacets();
            int i = 0;
            while (i < facetList.getLength()) {
                XSMultiValueFacet enumer;
                XSObject facet = facetList.item(i);
                if (facet.getType() == 14 && (enumer = (XSMultiValueFacet)facet).getFacetKind() == 2048) {
                    StringList enumList = enumer.getLexicalFacetValues();
                    datatype = new DatatypeEnumeration(enumList);
                }
                ++i;
            }
        } else {
            datatype = BuiltIn.getDatatypeOfType(std);
        }
        return datatype;
    }

    private static ExpandedName getXMLSchemaDatatype(XSSimpleTypeDefinition std) {
        ExpandedName exiDatatypeID;
        ExpandedName primitive = BuiltIn.getPrimitive(std);
        if (primitive.equals(XSD_DECIMAL)) {
            XSSimpleTypeDefinition xmlSchemaType = std;
            while (xmlSchemaType != null && (xmlSchemaType.getName() == null || !XSD_INTEGER.equals(BuiltIn.getName((XSTypeDefinition)xmlSchemaType)) && !XSD_NON_NEGATIVE_INTEGER.equals(BuiltIn.getName((XSTypeDefinition)xmlSchemaType)))) {
                xmlSchemaType = xmlSchemaType.getBaseType();
            }
            exiDatatypeID = xmlSchemaType == null ? XSD_DECIMAL : XSD_INTEGER;
        } else {
            exiDatatypeID = BuiltIn.getBuiltInOfPrimitiveMapping(primitive);
        }
        return exiDatatypeID;
    }

    private static Datatype getIntegerDatatype(XSSimpleTypeDefinition std, ExpandedName datatypeID) {
        AbstractDatatype datatype;
        BigInteger min = BigInteger.valueOf(Long.MIN_VALUE);
        BigInteger max = BigInteger.valueOf(Long.MAX_VALUE);
        try {
            if (std.isDefinedFacet((short)256)) {
                String sMinInclusive = std.getLexicalFacetValue((short)256);
                min = min.max(new BigInteger(sMinInclusive));
            }
            if (std.isDefinedFacet((short)128)) {
                String sMinExclusive = std.getLexicalFacetValue((short)128);
                min = min.max(new BigInteger(sMinExclusive).add(BigInteger.ONE));
            }
            if (std.isDefinedFacet((short)32)) {
                String sMaxInclusive = std.getLexicalFacetValue((short)32);
                max = max.min(new BigInteger(sMaxInclusive));
            }
            if (std.isDefinedFacet((short)64)) {
                String sMaxExclusive = std.getLexicalFacetValue((short)64);
                max = max.min(new BigInteger(sMaxExclusive).subtract(BigInteger.ONE));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("SimpleTypeDefinition invalid: " + std);
        }
        if (max.compareTo(min) == -1) {
            throw new RuntimeException("max=" + max + " and min=" + min);
        }
        BigInteger boundedRange = max.compareTo(BigInteger.ZERO) == -1 ? min.abs().subtract(max.abs()).add(BigInteger.ONE) : (min.compareTo(BigInteger.ZERO) == -1 ? max.add(min.abs()) : max.abs().subtract(min).add(BigInteger.ONE));
        if (boundedRange.compareTo(BigInteger.valueOf(4096L)) == -1) {
            try {
                XSDInteger lowerBound = XSDInteger.newInstance();
                lowerBound.parse(min.toString());
                XSDInteger upperBound = XSDInteger.newInstance();
                upperBound.parse(max.toString());
                datatype = new DatatypeNBitInteger(datatypeID, lowerBound, upperBound, boundedRange.intValue());
            }
            catch (XMLParsingException e) {
                throw new RuntimeException("Error occured while identifying XML Schema bounds", e);
            }
        } else {
            datatype = min.signum() >= 0 ? new DatatypeUnsignedInteger(datatypeID) : new DatatypeInteger(datatypeID);
        }
        return datatype;
    }

    private static ExpandedName getName(XSTypeDefinition type) {
        return new ExpandedName(type.getNamespace(), type.getName());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Datatype getDatatypeOfType(XSSimpleTypeDefinition std) {
        void var1_19;
        ExpandedName schemaDatatype = BuiltIn.getXMLSchemaDatatype(std);
        ExpandedName datatypeID = null;
        if (!std.getAnonymous()) {
            datatypeID = new ExpandedName(std.getNamespace(), std.getName());
        }
        if (XSD_BASE64BINARY.equals(schemaDatatype)) {
            DatatypeBinary datatypeBinary = new DatatypeBinary(datatypeID, BuiltInType.BUILTIN_BINARY_BASE64);
            return var1_19;
        } else if (XSD_HEXBINARY.equals(schemaDatatype)) {
            DatatypeBinary datatypeBinary = new DatatypeBinary(datatypeID, BuiltInType.BUILTIN_BINARY_HEX);
            return var1_19;
        } else if (XSD_BOOLEAN.equals(schemaDatatype)) {
            if (std.isDefinedFacet((short)8)) {
                DatatypeBooleanPattern datatypeBooleanPattern = new DatatypeBooleanPattern(datatypeID);
                return var1_19;
            } else {
                DatatypeBoolean datatypeBoolean = new DatatypeBoolean(datatypeID);
            }
            return var1_19;
        } else if (XSD_DATETIME.equals(schemaDatatype)) {
            ExpandedName primitive = BuiltIn.getPrimitive(std);
            if (XSD_DATETIME.equals(primitive)) {
                DatatypeDatetime datatypeDatetime = new DatatypeDatetime(DatetimeType.dateTime, datatypeID);
                return var1_19;
            } else if (XSD_TIME.equals(primitive)) {
                DatatypeDatetime datatypeDatetime = new DatatypeDatetime(DatetimeType.time, datatypeID);
                return var1_19;
            } else if (XSD_DATE.equals(primitive)) {
                DatatypeDatetime datatypeDatetime = new DatatypeDatetime(DatetimeType.date, datatypeID);
                return var1_19;
            } else if (XSD_GYEARMONTH.equals(primitive)) {
                DatatypeDatetime datatypeDatetime = new DatatypeDatetime(DatetimeType.gYearMonth, datatypeID);
                return var1_19;
            } else if (XSD_GYEAR.equals(primitive)) {
                DatatypeDatetime datatypeDatetime = new DatatypeDatetime(DatetimeType.gYear, datatypeID);
                return var1_19;
            } else if (XSD_GMONTHDAY.equals(primitive)) {
                DatatypeDatetime datatypeDatetime = new DatatypeDatetime(DatetimeType.gMonthDay, datatypeID);
                return var1_19;
            } else if (XSD_GDAY.equals(primitive)) {
                DatatypeDatetime datatypeDatetime = new DatatypeDatetime(DatetimeType.gDay, datatypeID);
                return var1_19;
            } else {
                if (!XSD_GMONTH.equals(primitive)) throw new RuntimeException();
                DatatypeDatetime datatypeDatetime = new DatatypeDatetime(DatetimeType.gMonth, datatypeID);
            }
            return var1_19;
        } else if (XSD_DECIMAL.equals(schemaDatatype)) {
            DatatypeDecimal datatypeDecimal = new DatatypeDecimal(datatypeID);
            return var1_19;
        } else if (XSD_DOUBLE.equals(schemaDatatype)) {
            DatatypeFloat datatypeFloat = new DatatypeFloat(datatypeID);
            return var1_19;
        } else if (XSD_INTEGER.equals(schemaDatatype)) {
            Datatype datatype = BuiltIn.getIntegerDatatype(std, datatypeID);
            return var1_19;
        } else {
            DatatypeString datatypeString = new DatatypeString(datatypeID);
        }
        return var1_19;
    }

    private static ExpandedName getPrimitive(XSSimpleTypeDefinition std) {
        XSSimpleTypeDefinition primitiveType = std.getPrimitiveType();
        ExpandedName primitiveQName = primitiveType == null ? XSD_ANY_SIMPLE_TYPE : new ExpandedName(primitiveType.getNamespace(), primitiveType.getName());
        return primitiveQName;
    }

    private static ExpandedName getBuiltInOfPrimitiveMapping(ExpandedName qnamePrimitive) {
        if (datatypeMapping.containsKey(qnamePrimitive)) {
            return datatypeMapping.get(qnamePrimitive);
        }
        return DEFAULT_VALUE_NAME;
    }
}

