/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.AbstractEXIDecoder;
import com.siemens.ct.exi.datatype.BuiltIn;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.GrammarSchemaInformed;
import com.siemens.ct.exi.grammar.TypeGrammar;
import com.siemens.ct.exi.grammar.event.Attribute;
import com.siemens.ct.exi.grammar.event.Characters;
import com.siemens.ct.exi.grammar.event.Event;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.event.StartDocument;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import com.siemens.ct.exi.util.ExpandedName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EXIDecoderReordered
extends AbstractEXIDecoder {
    protected List<Event> events = new ArrayList<Event>();
    protected List<EventType> eventTypes = new ArrayList<EventType>();
    protected int currentEventIndex;
    protected List<ExpandedName> genericElements = new ArrayList<ExpandedName>();
    protected int currentGenericElementsIndex;
    protected List<String> elementPrefixes = new ArrayList<String>();
    protected int currentElementPrefixIndex;
    protected List<String> attributePrefixes = new ArrayList<String>();
    protected int currentAttributePrefixIndex;
    protected List<ExpandedName> genericAttributes = new ArrayList<ExpandedName>();
    protected int currentGenericAttributesIndex;
    protected List<String> xsiTypeUris = new ArrayList<String>();
    protected List<String> xsiTypeNames = new ArrayList<String>();
    protected int currentXsiTypeIndex;
    protected List<Boolean> xsiNils = new ArrayList<Boolean>();
    protected int currentXsiNilsIndex;
    protected List<String> xsiNilsDeviation = new ArrayList<String>();
    protected int currentXsiNilsDeviationIndex;
    protected List<String> docTypes = new ArrayList<String>();
    protected int currentDocTypeIndex;
    protected List<String> entityReferences = new ArrayList<String>();
    protected int currentEntityReferenceIndex;
    protected List<String> comments = new ArrayList<String>();
    protected int currentCommentsIndex;
    protected List<String> uris = new ArrayList<String>();
    protected List<String> prefixes = new ArrayList<String>();
    protected int currentNamespacesIndex;
    protected List<String> piTargets = new ArrayList<String>();
    protected List<String> piDatas = new ArrayList<String>();
    protected int currentProcessingIntructionsIndex;
    protected int cntValues;
    protected List<ExpandedName> valueQNames = new ArrayList<ExpandedName>();
    protected Map<ExpandedName, Integer> occurrences = new HashMap<ExpandedName, Integer>();
    protected Map<ExpandedName, List<Datatype>> dataTypes = new HashMap<ExpandedName, List<Datatype>>();

    public EXIDecoderReordered(EXIFactory exiFactory) {
        super(exiFactory);
    }

    protected void initForEachRun() throws EXIException {
        super.initForEachRun();
        this.nextEvent = new StartDocument();
        this.nextEventType = EventType.START_DOCUMENT;
        this.events.clear();
        this.eventTypes.clear();
        this.currentEventIndex = 0;
        this.genericElements.clear();
        this.currentGenericElementsIndex = 0;
        this.elementPrefixes.clear();
        this.currentElementPrefixIndex = 0;
        this.attributePrefixes.clear();
        this.currentAttributePrefixIndex = 0;
        this.genericAttributes.clear();
        this.currentGenericAttributesIndex = 0;
        this.xsiNils.clear();
        this.currentXsiNilsIndex = 0;
        this.xsiNilsDeviation.clear();
        this.currentXsiNilsDeviationIndex = 0;
        this.docTypes.clear();
        this.currentDocTypeIndex = 0;
        this.entityReferences.clear();
        this.currentEntityReferenceIndex = 0;
        this.comments.clear();
        this.currentCommentsIndex = 0;
        this.uris.clear();
        this.prefixes.clear();
        this.currentNamespacesIndex = 0;
        this.piTargets.clear();
        this.piDatas.clear();
        this.currentProcessingIntructionsIndex = 0;
        this.cntValues = 0;
        this.valueQNames.clear();
        this.occurrences.clear();
        this.dataTypes.clear();
        if (this.exiFactory.isFragment()) {
            this.pushRule(this.grammar.getBuiltInFragmentGrammar());
        } else {
            this.pushRule(this.grammar.getBuiltInDocumentGrammar());
        }
        this.initStructure();
    }

    protected void initStructure() throws EXIException {
        try {
            boolean stillInitializing = true;
            block26: while (stillInitializing) {
                this.events.add(this.nextEvent);
                this.eventTypes.add(this.nextEventType);
                switch (this.nextEventType) {
                    case START_DOCUMENT: {
                        this.decodeStartDocumentInternal();
                        break;
                    }
                    case START_ELEMENT: {
                        this.decodeStartElementInternal();
                        break;
                    }
                    case START_ELEMENT_GENERIC: {
                        this.decodeStartElementGenericInternal();
                        break;
                    }
                    case START_ELEMENT_GENERIC_UNDECLARED: {
                        this.decodeStartElementUndeclaredInternal();
                        break;
                    }
                    case NAMESPACE_DECLARATION: {
                        this.decodeNamespaceDeclarationInternal();
                        break;
                    }
                    case ATTRIBUTE: {
                        this.decodeAttributeInternal();
                        break;
                    }
                    case ATTRIBUTE_INVALID_VALUE: {
                        this.decodeAttributeInvalidValueInternal();
                        break;
                    }
                    case ATTRIBUTE_GENERIC: {
                        this.decodeAttributeGenericInternal();
                        break;
                    }
                    case ATTRIBUTE_GENERIC_UNDECLARED: {
                        this.decodeAttributeGenericUndeclaredInternal();
                        break;
                    }
                    case ATTRIBUTE_XSI_TYPE: {
                        this.decodeAttributeXsiTypeInternal();
                        break;
                    }
                    case ATTRIBUTE_XSI_NIL: {
                        this.decodeAttributeXsiNilInternal();
                        break;
                    }
                    case ATTRIBUTE_XSI_NIL_DEVIATION: {
                        this.decodeAttributeXsiNilDeviationInternal();
                        break;
                    }
                    case CHARACTERS: {
                        this.decodeCharactersInternal();
                        break;
                    }
                    case CHARACTERS_GENERIC: {
                        this.decodeCharactersGenericInternal();
                        break;
                    }
                    case CHARACTERS_GENERIC_UNDECLARED: {
                        this.decodeCharactersUndeclaredInternal();
                        break;
                    }
                    case END_ELEMENT: {
                        this.decodeEndElementInternal();
                        break;
                    }
                    case END_ELEMENT_UNDECLARED: {
                        this.decodeEndElementUndeclaredInternal();
                        break;
                    }
                    case END_DOCUMENT: {
                        this.decodeEndDocumentInternal();
                        stillInitializing = false;
                        continue block26;
                    }
                    case DOC_TYPE: {
                        this.decodeDocTypeInternal();
                        break;
                    }
                    case ENTITY_REFERENCE: {
                        this.decodeEntityReferenceInternal();
                        break;
                    }
                    case COMMENT: {
                        this.decodeCommentInternal();
                        break;
                    }
                    case PROCESSING_INSTRUCTION: {
                        this.decodeProcessingInstructionInternal();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown Event " + (Object)((Object)this.nextEventType));
                    }
                }
                this.decodeEventCode();
            }
            this.block.reconstructChannels(this.cntValues, this.valueQNames, this.dataTypes, this.occurrences);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected Event stepToNextEvent() {
        return this.events.get(this.currentEventIndex++);
    }

    public void inspectEvent() throws EXIException {
    }

    public boolean hasNextEvent() {
        return this.events.size() > this.currentEventIndex + 1;
    }

    public EventType getNextEventType() {
        return this.eventTypes.get(this.currentEventIndex);
    }

    protected void incrementValues(ExpandedName qnameConent, Datatype datatype) {
        ++this.cntValues;
        if (this.valueQNames.contains(qnameConent)) {
            this.occurrences.put(qnameConent, this.occurrences.get(qnameConent) + 1);
        } else {
            this.occurrences.put(qnameConent, 1);
            this.dataTypes.put(qnameConent, new ArrayList());
            this.valueQNames.add(qnameConent);
        }
        this.dataTypes.get(qnameConent).add(datatype);
    }

    protected void decodeStartDocumentInternal() throws EXIException {
        this.decodeStartDocumentStructure();
    }

    public void decodeStartDocument() throws EXIException {
        Event ev = this.stepToNextEvent();
        assert (ev.isEventType(EventType.START_DOCUMENT));
    }

    protected void decodeStartElementInternal() throws EXIException {
        this.decodeStartElementStructure();
        this.elementPrefixes.add(this.elementPrefix);
    }

    public void decodeStartElement() throws EXIException {
        StartElement se = (StartElement)this.stepToNextEvent();
        this.elementURI = se.getNamespaceURI();
        this.elementLocalName = se.getLocalPart();
        this.elementPrefix = this.elementPrefixes.get(this.currentElementPrefixIndex++);
        this.pushScope(this.elementURI, this.elementLocalName);
    }

    protected void decodeStartElementGenericInternal() throws EXIException {
        this.decodeStartElementGenericStructure();
        this.genericElements.add(new ExpandedName(this.elementURI, this.elementLocalName));
        this.elementPrefixes.add(this.elementPrefix);
    }

    public void decodeStartElementGeneric() throws EXIException {
        this.stepToNextEvent();
        ExpandedName qname = this.genericElements.get(this.currentGenericElementsIndex++);
        this.elementURI = qname.getNamespaceURI();
        this.elementLocalName = qname.getLocalName();
        this.elementPrefix = this.elementPrefixes.get(this.currentElementPrefixIndex++);
        this.pushScope(this.elementURI, this.elementLocalName);
    }

    protected void decodeStartElementUndeclaredInternal() throws EXIException {
        this.decodeStartElementGenericUndeclaredStructure();
        this.genericElements.add(new ExpandedName(this.elementURI, this.elementLocalName));
        this.elementPrefixes.add(this.elementPrefix);
    }

    public void decodeStartElementGenericUndeclared() throws EXIException {
        this.stepToNextEvent();
        ExpandedName qname = this.genericElements.get(this.currentGenericElementsIndex++);
        this.elementURI = qname.getNamespaceURI();
        this.elementLocalName = qname.getLocalName();
        this.elementPrefix = this.elementPrefixes.get(this.currentElementPrefixIndex++);
        this.pushScope(this.elementURI, this.elementLocalName);
    }

    protected void decodeNamespaceDeclarationInternal() throws EXIException {
        this.decodeNamespaceDeclarationStructure();
        this.uris.add(this.nsURI);
        this.prefixes.add(this.nsPrefix);
    }

    public void decodeNamespaceDeclaration() throws EXIException {
        Event ev = this.stepToNextEvent();
        assert (ev.isEventType(EventType.NAMESPACE_DECLARATION));
        this.nsURI = this.uris.get(this.currentNamespacesIndex);
        this.nsPrefix = this.prefixes.get(this.currentNamespacesIndex++);
    }

    protected void decodeAttributeInternal() throws EXIException {
        Attribute at = this.decodeAttributeStructure();
        this.attributePrefixes.add(this.attributePrefix);
        this.incrementValues(new ExpandedName(at.getNamespaceURI(), at.getLocalPart()), at.getDatatype());
    }

    protected void decodeAttributeInvalidValueInternal() throws EXIException {
        Attribute at = this.decodeAttributeStructure();
        this.attributePrefixes.add(this.attributePrefix);
        this.incrementValues(new ExpandedName(at.getNamespaceURI(), at.getLocalPart()), BuiltIn.DEFAULT_DATATYPE);
    }

    public void decodeAttribute() throws EXIException {
        Attribute at = (Attribute)this.stepToNextEvent();
        this.attributeURI = at.getNamespaceURI();
        this.attributeLocalName = at.getLocalPart();
        this.attributePrefix = this.attributePrefixes.get(this.currentAttributePrefixIndex++);
        try {
            this.attributeValue = this.block.readTypedValidValue(at.getDatatype(), this.attributeURI, this.attributeLocalName);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void decodeAttributeInvalidValue() throws EXIException {
        Attribute at = (Attribute)this.stepToNextEvent();
        this.attributeURI = at.getNamespaceURI();
        this.attributeLocalName = at.getLocalPart();
        this.attributePrefix = this.attributePrefixes.get(this.currentAttributePrefixIndex++);
        try {
            this.attributeValue = this.block.readValueAsString(this.attributeURI, this.attributeLocalName);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeAttributeGenericInternal() throws EXIException {
        this.decodeAttributeGenericStructure();
        ExpandedName n = new ExpandedName(this.attributeURI, this.attributeLocalName);
        this.genericAttributes.add(n);
        this.attributePrefixes.add(this.attributePrefix);
        this.incrementValues(n, BuiltIn.DEFAULT_DATATYPE);
    }

    protected void decodeAttributeGenericUndeclaredInternal() throws EXIException {
        this.decodeAttributeGenericUndeclaredStructure();
        ExpandedName n = new ExpandedName(this.attributeURI, this.attributeLocalName);
        this.genericAttributes.add(n);
        this.attributePrefixes.add(this.attributePrefix);
        this.incrementValues(n, BuiltIn.DEFAULT_DATATYPE);
    }

    public void decodeAttributeGeneric() throws EXIException {
        try {
            this.stepToNextEvent();
            ExpandedName n = this.genericAttributes.get(this.currentGenericAttributesIndex++);
            this.attributeURI = n.getNamespaceURI();
            this.attributeLocalName = n.getLocalName();
            this.attributePrefix = this.attributePrefixes.get(this.currentAttributePrefixIndex++);
            this.attributeValue = this.block.readValueAsString(this.attributeURI, this.attributeLocalName);
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void decodeAttributeGenericUndeclared() throws EXIException {
        this.decodeAttributeGeneric();
    }

    protected void decodeAttributeXsiTypeInternal() throws EXIException {
        this.decodeAttributeXsiType();
        TypeGrammar tg = ((GrammarSchemaInformed)this.grammar).getTypeGrammar(this.xsiTypeUri, this.xsiTypeName);
        if (tg != null) {
            this.replaceRuleAtTheTop(tg.getType());
            this.pushScopeType(this.xsiTypeUri, this.xsiTypeName);
        }
        this.xsiTypeUris.add(this.xsiTypeUri);
        this.xsiTypeNames.add(this.xsiTypeName);
    }

    public void decodeXsiType() throws EXIException {
        this.stepToNextEvent();
        this.xsiTypeUri = this.xsiTypeUris.get(this.currentXsiTypeIndex);
        this.xsiTypeName = this.xsiTypeNames.get(this.currentXsiTypeIndex++);
    }

    protected void decodeAttributeXsiNilInternal() throws EXIException {
        this.decodeAttributeXsiNil();
        if (this.xsiNil && this.currentRule instanceof SchemaInformedRule) {
            this.replaceRuleAtTheTop(((SchemaInformedRule)this.currentRule).getTypeEmpty());
        }
        this.xsiNils.add(this.xsiNil);
    }

    public void decodeXsiNil() throws EXIException {
        this.stepToNextEvent();
        this.xsiNil = this.xsiNils.get(this.currentXsiNilsIndex++);
    }

    protected void decodeAttributeXsiNilDeviationInternal() throws EXIException {
        this.decodeAttributeXsiNilDeviation();
        this.xsiNilsDeviation.add(this.xsiNilDeviation);
    }

    public void decodeXsiNilDeviation() throws EXIException {
        this.stepToNextEvent();
        this.xsiNilDeviation = this.xsiNilsDeviation.get(this.currentXsiNilsDeviationIndex++);
    }

    protected void decodeCharactersInternal() throws EXIException {
        try {
            Characters ch = this.decodeCharactersStructure();
            this.incrementValues(new ExpandedName(this.getScopeURI(), this.getScopeLocalName()), ch.getDatatype());
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    public void decodeCharacters() throws EXIException {
        try {
            Characters ch = (Characters)this.stepToNextEvent();
            this.characters = this.block.readTypedValidValue(ch.getDatatype(), this.getScopeURI(), this.getScopeLocalName());
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeCharactersGenericInternal() throws EXIException {
        this.decodeCharactersGenericStructure();
        this.incrementValues(new ExpandedName(this.getScopeURI(), this.getScopeLocalName()), BuiltIn.DEFAULT_DATATYPE);
    }

    public void decodeCharactersGeneric() throws EXIException {
        try {
            this.stepToNextEvent();
            this.characters = this.block.readValueAsString(this.getScopeURI(), this.getScopeLocalName());
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeCharactersUndeclaredInternal() throws EXIException {
        this.decodeCharactersUndeclaredStructure();
        this.incrementValues(new ExpandedName(this.getScopeURI(), this.getScopeLocalName()), BuiltIn.DEFAULT_DATATYPE);
    }

    public void decodeCharactersGenericUndeclared() throws EXIException {
        try {
            this.stepToNextEvent();
            this.characters = this.block.readValueAsString(this.getScopeURI(), this.getScopeLocalName());
        }
        catch (IOException e) {
            throw new EXIException(e);
        }
    }

    protected void decodeEndElementInternal() throws EXIException {
        this.decodeEndElementStructure();
    }

    public void decodeEndElement() throws EXIException {
        this.stepToNextEvent();
        this.popScope();
    }

    protected void decodeEndElementUndeclaredInternal() throws EXIException {
        this.decodeEndElementUndeclaredStructure();
    }

    public void decodeEndElementUndeclared() throws EXIException {
        this.decodeEndElement();
    }

    protected void decodeEndDocumentInternal() throws EXIException {
        this.decodeEndDocumentStructure();
    }

    public void decodeEndDocument() throws EXIException {
        Event ev = this.stepToNextEvent();
        assert (ev.isEventType(EventType.END_DOCUMENT));
    }

    protected void decodeDocTypeInternal() throws EXIException {
        this.decodeDocTypeStructure();
        this.docTypes.add(this.docTypeName);
        this.docTypes.add(this.docTypePublicID);
        this.docTypes.add(this.docTypeSystemID);
        this.docTypes.add(this.docTypeText);
    }

    public void decodeDocType() throws EXIException {
        Event ev = this.stepToNextEvent();
        assert (ev.isEventType(EventType.DOC_TYPE));
        this.docTypeName = this.docTypes.get(this.currentDocTypeIndex++);
        this.docTypePublicID = this.docTypes.get(this.currentDocTypeIndex++);
        this.docTypeSystemID = this.docTypes.get(this.currentDocTypeIndex++);
        this.docTypeText = this.docTypes.get(this.currentDocTypeIndex++);
    }

    protected void decodeEntityReferenceInternal() throws EXIException {
        this.decodeEntityReferenceStructure();
        this.entityReferences.add(this.entityReferenceName);
    }

    public void decodeEntityReference() throws EXIException {
        Event ev = this.stepToNextEvent();
        assert (ev.isEventType(EventType.ENTITY_REFERENCE));
        this.entityReferenceName = this.entityReferences.get(this.currentEntityReferenceIndex++);
    }

    protected void decodeCommentInternal() throws EXIException {
        this.decodeCommentStructure();
        this.comments.add(this.comment);
    }

    public void decodeComment() throws EXIException {
        Event ev = this.stepToNextEvent();
        assert (ev.isEventType(EventType.COMMENT));
        this.comment = this.comments.get(this.currentCommentsIndex++);
    }

    protected void decodeProcessingInstructionInternal() throws EXIException {
        this.decodeProcessingInstructionStructure();
        this.piTargets.add(this.piTarget);
        this.piDatas.add(this.piData);
    }

    public void decodeProcessingInstruction() throws EXIException {
        Event ev = this.stepToNextEvent();
        assert (ev.isEventType(EventType.PROCESSING_INSTRUCTION));
        this.piTarget = this.piTargets.get(this.currentProcessingIntructionsIndex);
        this.piData = this.piDatas.get(this.currentProcessingIntructionsIndex++);
    }

    public void decodeStartFragmentSelfContained() throws EXIException {
        throw new EXIException("SelfContained does NOT support reordered channels such as used in Compression and Pre-Compression mode");
    }

    public void decodeEndFragmentSelfContained() throws EXIException {
        throw new EXIException("SelfContained does NOT support reordered channels such as used in Compression and Pre-Compression mode");
    }
}

