/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.exceptions.ErrorHandler;
import com.siemens.ct.exi.grammar.ElementKey;
import com.siemens.ct.exi.grammar.Grammar;
import com.siemens.ct.exi.grammar.GrammarSchemaInformed;
import com.siemens.ct.exi.grammar.TypeGrammar;
import com.siemens.ct.exi.grammar.event.Attribute;
import com.siemens.ct.exi.grammar.event.AttributeGeneric;
import com.siemens.ct.exi.grammar.event.Characters;
import com.siemens.ct.exi.grammar.event.CharactersGeneric;
import com.siemens.ct.exi.grammar.event.EndDocument;
import com.siemens.ct.exi.grammar.event.EndElement;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.event.StartElementGeneric;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.RuleStartTagSchemaLess;
import com.siemens.ct.exi.helpers.DefaultErrorHandler;
import com.siemens.ct.exi.util.ExpandedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractEXICoder {
    protected final EndDocument eventED;
    protected final StartElement eventSE;
    protected final StartElementGeneric eventSEg;
    protected final EndElement eventEE;
    protected final Attribute eventAT;
    protected final AttributeGeneric eventATg;
    protected final Characters eventCH;
    protected final CharactersGeneric eventCHg;
    protected EXIFactory exiFactory;
    protected Grammar grammar;
    protected FidelityOptions fidelityOptions;
    protected ErrorHandler errorHandler;
    protected Map<String, Map<String, Rule>> runtimeDispatcher;
    protected List<String> scopeURI;
    protected List<String> scopeLocalName;
    protected List<String> scopeTypeURI;
    protected List<String> scopeTypeLocalName;
    protected NamespaceSupport namespaces;
    protected List<Rule> openRules;
    protected Rule currentRule;
    private ElementKey ruleKey;
    private ExpandedName ruleName;
    private ExpandedName ruleScope;
    private ExpandedName ruleScopeType;

    public AbstractEXICoder(EXIFactory exiFactory) {
        this.exiFactory = exiFactory;
        this.grammar = exiFactory.getGrammar();
        this.fidelityOptions = exiFactory.getFidelityOptions();
        this.eventED = new EndDocument();
        this.eventSE = new StartElement(null, null);
        this.eventSEg = new StartElementGeneric();
        this.eventEE = new EndElement();
        this.eventAT = new Attribute(null, null);
        this.eventATg = new AttributeGeneric();
        this.eventCH = new Characters(null, null);
        this.eventCHg = new CharactersGeneric();
        this.ruleKey = new ElementKey(null);
        this.ruleName = new ExpandedName(null, "");
        this.ruleScope = new ExpandedName(null, "");
        this.ruleScopeType = new ExpandedName(null, "");
        this.namespaces = new NamespaceSupport();
        this.errorHandler = new DefaultErrorHandler();
        this.initOnce();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void initOnce() {
        this.runtimeDispatcher = new HashMap<String, Map<String, Rule>>();
        this.openRules = new ArrayList<Rule>();
        this.scopeURI = new ArrayList<String>();
        this.scopeLocalName = new ArrayList<String>();
        this.scopeTypeURI = new ArrayList<String>();
        this.scopeTypeLocalName = new ArrayList<String>();
    }

    protected void initForEachRun() throws EXIException {
        this.runtimeDispatcher.clear();
        this.openRules.clear();
        this.currentRule = null;
        this.pushRule(null);
        this.scopeURI.clear();
        this.scopeLocalName.clear();
        this.pushScope(null, null);
        this.scopeTypeURI.clear();
        this.scopeTypeLocalName.clear();
        this.pushScopeType(null, null);
        this.namespaces.reset();
    }

    protected void pushScope(String uri, String localName) {
        this.scopeURI.add(uri);
        this.scopeLocalName.add(localName);
        this.namespaces.pushContext();
    }

    protected final void pushScopeType(String uri, String localName) {
        this.scopeTypeURI.add(uri);
        this.scopeTypeLocalName.add(localName);
    }

    protected void popScope() {
        this.scopeURI.remove(this.scopeURI.size() - 1);
        this.scopeLocalName.remove(this.scopeLocalName.size() - 1);
        this.namespaces.popContext();
    }

    public final String getScopeURI() {
        return this.scopeURI.get(this.scopeURI.size() - 1);
    }

    public final String getScopeLocalName() {
        return this.scopeLocalName.get(this.scopeLocalName.size() - 1);
    }

    public NamespaceSupport getNamespaces() {
        return this.namespaces;
    }

    protected final String getScopeTypeURI() {
        return this.scopeTypeURI.get(this.scopeTypeURI.size() - 1);
    }

    protected final String getScopeTypeLocalName() {
        return this.scopeTypeLocalName.get(this.scopeTypeLocalName.size() - 1);
    }

    protected final void replaceRuleAtTheTop(Rule top) {
        assert (!this.openRules.isEmpty());
        assert (top != null);
        if (top != this.currentRule) {
            this.currentRule = top;
            this.openRules.set(this.openRules.size() - 1, this.currentRule);
        }
    }

    protected final void pushRule(Rule r) {
        this.currentRule = r;
        this.openRules.add(this.currentRule);
    }

    protected final void popRule() {
        assert (!this.openRules.isEmpty());
        int size = this.openRules.size();
        this.openRules.remove(size - 1);
        this.currentRule = this.openRules.get(size - 2);
    }

    protected void pushRule(String namespaceURI, String localName) {
        Rule ruleToPush = null;
        if (this.grammar.isSchemaInformed()) {
            ruleToPush = this.getSchemaRuleForElement(namespaceURI, localName);
            if (ruleToPush == null) {
                TypeGrammar urType = ((GrammarSchemaInformed)this.grammar).getUrType();
                ruleToPush = urType.getType();
            }
        } else {
            ruleToPush = this.getRuntimeRuleForElement(namespaceURI, localName);
        }
        this.pushRule(ruleToPush);
    }

    private Rule getSchemaRuleForElement(String namespaceURI, String localName) {
        Rule ruleSchema = null;
        this.ruleName.setLocalName(localName);
        this.ruleName.setNamespaceURI(namespaceURI);
        this.ruleKey.setName(this.ruleName);
        this.ruleKey.setScope(null);
        this.ruleKey.setScopeType(null);
        ruleSchema = this.grammar.getRule(this.ruleKey);
        if (ruleSchema == null) {
            if (this.getScopeLocalName() != null) {
                this.ruleScope.setLocalName(this.getScopeLocalName());
                this.ruleScope.setNamespaceURI(this.getScopeURI());
                this.ruleKey.setScope(this.ruleScope);
            } else {
                this.ruleKey.setScope(null);
            }
            ruleSchema = this.grammar.getRule(this.ruleKey);
            if (ruleSchema == null && this.getScopeTypeLocalName() != null) {
                this.ruleKey.setScope(null);
                this.ruleScopeType.setLocalName(this.getScopeTypeLocalName());
                this.ruleScopeType.setNamespaceURI(this.getScopeTypeURI());
                this.ruleKey.setScopeType(this.ruleScopeType);
                ruleSchema = this.grammar.getRule(this.ruleKey);
            }
        }
        return ruleSchema;
    }

    private Rule getRuntimeRuleForElement(String namespaceURI, String localName) {
        Rule r;
        Map<String, Rule> mapNS = this.runtimeDispatcher.get(namespaceURI);
        if (mapNS == null) {
            mapNS = new HashMap<String, Rule>();
            this.runtimeDispatcher.put(namespaceURI, mapNS);
            r = new RuleStartTagSchemaLess();
            mapNS.put(localName, r);
        } else {
            r = mapNS.get(localName);
            if (r == null) {
                r = new RuleStartTagSchemaLess();
                mapNS.put(localName, r);
            }
        }
        return r;
    }
}

