package com.yuji.em.task;

import java.lang.ref.WeakReference;

import com.evernote.edam.notestore.NoteList;
import com.yuji.em.NoteListActivity;
import com.yuji.em.utility.AsyncTaskIF;
import com.yuji.em.utility.EvernoteUtil;

public class NoteListTask implements AsyncTaskIF {
	private EvernoteUtil util = EvernoteUtil.getInstance();
	private NoteList noteList;
	private WeakReference<NoteListActivity> activityRef;
	private EvernoteUtil.Error errorCode = null;

	public NoteListTask(NoteListActivity activity) {
		activityRef = new WeakReference<NoteListActivity>(activity);
	}

	@Override
	public void doExecute() {
		synchronized (util) {
			try {
				noteList = util.getNoteList();
			} finally {
				errorCode = util.getErrorCode();
			}
		}
	}

	@Override
	public void cancel() {

	}

	@Override
	public void done(boolean isCancel) {
		NoteListActivity activity = activityRef.get();
		if (activity != null) {
			activity.done((!isCancel ? noteList : null), errorCode);
			activityRef = null;
		}
	}

	@Override
	public int getStatus() {
		return 0;
	}

	public NoteList getNoteList() {
		return noteList;
	}

	public EvernoteUtil.Error getErrorCode() {
		return errorCode;
	}
}
