package com.yuji.em;

import java.util.ArrayList;
import java.util.List;

import android.content.Intent;
import android.os.Bundle;
import android.text.format.DateUtils;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.Button;
import android.widget.ListView;
import android.widget.Toast;

import com.evernote.edam.notestore.NoteList;
import com.yuji.em.common.Constant;
import com.yuji.em.data.Note;
import com.yuji.em.data.NoteDao;
import com.yuji.em.task.NoteListTask;
import com.yuji.em.utility.AsyncTaskCommand;
import com.yuji.em.utility.BaseActivity;
import com.yuji.em.utility.EvernoteUtil;
import com.yuji.em.utility.EvernoteUtil.Error;

public class NoteListActivity extends BaseActivity {
	private static List<NoteListItem> noteList = null;

	private ListView listView = null;
	private Button closeButton = null;
	private int index = -1;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.note_list);

		try {
			listView = (ListView) this.findViewById(R.id.noteListView);
			closeButton = (Button) this.findViewById(R.id.noteListCloseButton);

			listView.setOnItemClickListener(new OnItemClickListener() {
				public void onItemClick(AdapterView<?> parent, View view,
						int position, long id) {
					listViewOnItemClickListener(parent, view, position, id);
				}
			});

			closeButton.setOnClickListener(new OnClickListener() {
				public void onClick(View v) {
					closeButtonOnClick();
				}
			});

			Bundle extras = getIntent().getExtras();
			index = extras.getInt(Constant.EXTRA_INDEX);

			if (noteList != null) {
				setNoteList(noteList);
			} else {
				NoteListTask task = new NoteListTask(this);
				AsyncTaskCommand command = new AsyncTaskCommand(this, task);
				command.setTitle(getString(R.string.noteListGetting));
				command.setButtonTitle(getString(R.string.cancelButton));
				command.execute("");
			}
		} catch (Exception e) {
			terminate(e);
		}
	}

	private void closeButtonOnClick() {
		Intent intent = new Intent();
		setResult(RESULT_CANCELED, intent);
		finish();
	}

	private void listViewOnItemClickListener(AdapterView<?> parent, View view,
			int position, long id) {
		ListView listView = (ListView) parent;
		NoteListItem item = (NoteListItem) listView.getItemAtPosition(position);

		Note note = item.getNote();
		if (note == null) {
			return;
		}

		NoteDao dao = NoteDao.getInstance();
		int n = dao.search(this, note);
		if (n >= 0) {
			// #27613
			Intent intent = new Intent();
			setResult(RESULT_CANCELED, intent);
			finish();
			return;
		}
		dao.update(this, note, index);

		Intent intent = new Intent();
		setResult(RESULT_OK, intent);
		finish();
	}

	public void done(List<NoteList> nListList, Error errorCode) {
		if (errorCode != null && !errorCode.equals(Error.NONE)) {
				EvernoteUtil util = EvernoteUtil.getInstance();
				Toast.makeText(this, util.getErrorMessage(this, errorCode),
						Toast.LENGTH_LONG).show();
		}

		if (nListList == null) {
			// LZ{^
			closeButtonOnClick();
			return;
		}

		List<NoteListItem> list = getNoteList(nListList);
		if (list == null) {
			closeButtonOnClick();
			return;
		}
		setNoteList(list);
		noteList = list;
	}

	private void setNoteList(List<NoteListItem> list) {
		NoteListViewArrayAdapter adapter = new NoteListViewArrayAdapter(this,
				R.layout.simple_list_item_1, list);
		listView.setAdapter(adapter);
	}

	private List<NoteListItem> getNoteList(List<NoteList> nListList) {
		List<NoteListItem> list = new ArrayList<NoteListItem>();
		for (NoteList noteList : nListList){
			List<NoteListItem> l = getNoteList(noteList);
			if (l == null){
				return null;
			}
			list.addAll(l);
		}
		return list;
	}
	
	private List<NoteListItem> getNoteList(NoteList nList) {
		List<com.evernote.edam.type.Note> notes = nList.getNotes();
		if (notes == null) {
			return null;
		}

		List<NoteListItem> list = new ArrayList<NoteListItem>();
		String oldTitle = "";
		NoteListItem item;
		
		for (com.evernote.edam.type.Note note : notes) {
			long l = note.getUpdated();
			// long l = note.getCreated(); // \[ǵAXV
			String title = DateUtils.formatDateTime(this, l,
					DateUtils.FORMAT_SHOW_YEAR | DateUtils.FORMAT_SHOW_DATE);
			if (!title.equals(oldTitle)) {
				item = new NoteListItem(title, null);
				list.add(item);
				oldTitle = title;
			}

			Note n = new Note(note.getGuid(), note.getTitle());
			item = new NoteListItem(null, n);
			list.add(item);
		}
		return list;
	}

	public static void init() {
		noteList = null;
	}
}
