package com.yuji.em;

import java.util.Calendar;
import java.util.List;

import android.content.Intent;
import android.os.AsyncTask.Status;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.format.DateUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.ToggleButton;

import com.yuji.em.common.CommonUtil;
import com.yuji.em.common.Constant;
import com.yuji.em.data.Note;
import com.yuji.em.data.NoteDao;
import com.yuji.em.task.UpdateNoteTask;
import com.yuji.em.utility.AsyncTaskCommand;
import com.yuji.em.utility.BaseActivity;
import com.yuji.em.utility.Debug;
import com.yuji.em.utility.EditPrefUtil;

public class EverMemoActivity extends BaseActivity {
	private EditPrefUtil pref = new EditPrefUtil(this);
	private TextView titleText = null;
	private Button sendButton = null;
	private EditText editText = null;
	private ToggleButton[] toggleButton = new ToggleButton[Constant.TOGGLE_SIZE];
	private int selectedIndex = -1;
	private boolean checkFlag = false;
	private List<Note> noteList;
	private boolean isEmpty = true;

	private static boolean isInit = true;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		titleText = (TextView) this.findViewById(R.id.mainTitle);
		sendButton = (Button) this.findViewById(R.id.mainSendButton);
		editText = (EditText) this.findViewById(R.id.mainEditText);
		toggleButton[0] = (ToggleButton) this
				.findViewById(R.id.mainToggleButton1);
		toggleButton[1] = (ToggleButton) this
				.findViewById(R.id.mainToggleButton2);
		toggleButton[2] = (ToggleButton) this
				.findViewById(R.id.mainToggleButton3);
		toggleButton[3] = (ToggleButton) this
				.findViewById(R.id.mainToggleButton4);
		toggleButton[4] = (ToggleButton) this
				.findViewById(R.id.mainToggleButton5);

		sendButton.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				sendButtonOnClick();
			}
		});

		editText.addTextChangedListener(new TextWatcher() {
			@Override
			public void afterTextChanged(Editable s) {
				updateText();
			}

			@Override
			public void beforeTextChanged(CharSequence s, int start, int count,
					int after) {

			}

			@Override
			public void onTextChanged(CharSequence s, int start, int before,
					int count) {

			}
		});

		for (int i = 0; i < Constant.TOGGLE_SIZE; i++) {
			toggleButton[i]
					.setOnCheckedChangeListener(new OnCheckedChangeListener() {
						public void onCheckedChanged(CompoundButton buttonView,
								boolean isChecked) {
							toggleButtonOnCheckedChanged(buttonView, isChecked);
						}
					});
		}

		updateList();
		setStatus();
	}

	@Override
	protected void onStart() {
		super.onStart();

		if (isEmpty) {
			if (isInit) {
				Intent intent = new Intent(this,
						(Class<?>) SettingActivity.class);
				startActivityForResult(intent, 0);

				isInit = false;
			}
			else {
				finish();
				isInit = true;
			}
		}
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		updateList();
		setStatus();
		editText.setText("");
		updateText();
	}

	private void toggleButtonOnCheckedChanged(CompoundButton buttonView,
			boolean isChecked) {
		if (checkFlag) {
			return;
		}

		if (!isChecked) {
			buttonView.setChecked(true);
			return;
		}

		checkFlag = true;
		int index = getToggleButtonIndex(buttonView);
		for (int i = 0; i < Constant.TOGGLE_SIZE; i++) {
			if (i != index) {
				toggleButton[i].setChecked(false);
			}
		}
		String text = noteList.get(index).getTitle();
		titleText.setText(text);

		selectedIndex = index;
		pref.put(Constant.PREF_NOTE_INDEX, selectedIndex);
		pref.update();

		checkFlag = false;
	}

	private int getToggleButtonIndex(CompoundButton button) {
		int i = -1;
		for (i = 0; i < Constant.TOGGLE_SIZE; i++) {
			if (toggleButton[i] == button) {
				break;
			}
		}
		return i;
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		boolean ret = super.onCreateOptionsMenu(menu);
		menu.add(Menu.NONE, Menu.FIRST, Menu.NONE, R.string.mainMenuSetting);
		// menu.add(Menu.NONE, Menu.FIRST + 1, Menu.NONE,
		// R.string.mainMenuSetting);
		return ret;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		Intent intent;
		try {
			switch (item.getItemId()) {
			case Menu.FIRST:
				intent = new Intent(this, (Class<?>) SettingActivity.class);
				startActivityForResult(intent, 0);
				break;
			default:
				break;
			}
		} catch (Exception e) {
			terminate(e);
		}
		return super.onOptionsItemSelected(item);
	}

	private void updateList() {
		NoteDao dao = NoteDao.getInstance();
		noteList = dao.search(this);

		isEmpty = dao.isEmpty(noteList);
	}

	private void updateText() {
		String text = editText.getText().toString();
		sendButton.setEnabled(!CommonUtil.isNull(text) && !isEmpty);
	}

	private void sendButtonOnClick() {
		try {
			Note note = noteList.get(selectedIndex);
			String guid = note.getGuid();

			// http://y-anz-m.blogspot.com/2011/06/android.html
			// http://www.taosoftware.co.jp/blog/2009/03/android_20.html
			// String title = "<hr /><h3>%DATE%</h3><hr />";
			String title = pref.get(Constant.PREF_HEADER,
					Constant.DEFAULT_HEADER_TEXT);
			pref.update();

			Calendar cal = Calendar.getInstance();
			long l = cal.getTimeInMillis();
			String dateStr = DateUtils.formatDateTime(this, l,
					DateUtils.FORMAT_SHOW_YEAR | DateUtils.FORMAT_SHOW_DATE);
			String timeStr = DateUtils.formatDateTime(this, l,
					DateUtils.FORMAT_SHOW_TIME);

			title = CommonUtil.replaceString(title, "\\{DATE\\}", dateStr);
			title = CommonUtil.replaceString(title, "\\{TIME\\}", timeStr);

			// HTML
			String text = editText.getText().toString();
			text = CommonUtil.escapeHtml(text);

			// s
			String nl = System.getProperty("line.separator");
			List<String> lines = CommonUtil.split(text, nl);
			StringBuffer sb = new StringBuffer();
			for (String line : lines) {
				sb.append("<div>");
				if (line.equals("")) {
					line = "<br clear=\'none\'/>";
				}
				sb.append(line);
				sb.append("</div>");
			}
			text = sb.toString();

			// XV
			// util.updateNoteContext(guid, title, text);
			UpdateNoteTask task = new UpdateNoteTask(this, guid,
					note.getTitle(), title, text);
			AsyncTaskCommand command = new AsyncTaskCommand(this, task);
			command.setDialog(false);
			command.execute("");
			Status status = command.getStatus();

			editText.setText("");
		} catch (RuntimeException e) {
			Debug.d(this, null, e);
			throw e;
		} catch (Exception e) {
			terminate(e);
		}
	}

	private void setStatus() {
		Note note;
		boolean b;

		selectedIndex = pref.getInt(Constant.PREF_NOTE_INDEX, -1);
		titleText.setText("");
		if (selectedIndex >= 0) {
			note = noteList.get(selectedIndex);
			b = !CommonUtil.isNull(note.getGuid());
			if (b) {
				toggleButton[selectedIndex].setChecked(true);
				titleText.setText(note.getTitle());
			} else {
				checkFlag = true;
				toggleButton[selectedIndex].setChecked(false);
				checkFlag = false;
				// 
				selectedIndex = -1;
				pref.put(Constant.PREF_NOTE_INDEX, selectedIndex);
				pref.update();
			}
		}
		for (int i = 0; i < toggleButton.length; i++) {
			note = noteList.get(i);
			b = !CommonUtil.isNull(note.getGuid());
			toggleButton[i].setEnabled(b);
			if (selectedIndex < 0 && b) {
				selectedIndex = i;
				toggleButton[i].setChecked(true);
				titleText.setText(note.getTitle());
				pref.put(Constant.PREF_NOTE_INDEX, selectedIndex);
				pref.update();
			}
		}

		updateText();
		editText.setEnabled(!isEmpty);
	}

	public static void init(boolean flag) {
		isInit = flag;
	}

}