package com.yuji.em.data;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;

import com.yuji.em.common.CommonUtil;
import com.yuji.em.common.Constant;
import com.yuji.em.utility.EditPrefUtil;

public class NoteDao {
	private static final String DELM = "\t";
	private static NoteDao instance;
	private int size = Constant.TOGGLE_SIZE;

	public static NoteDao getInstance() {
		if (instance == null) {
			instance = new NoteDao();
		}
		return instance;
	}

	public List<Note> search(Context context) {
		EditPrefUtil pref = new EditPrefUtil(context);
		return search(context, pref);
	}

	public void update(Context context, Note note) {
		int index = search(context, note);
		if (index < 0){
			return;
		}
		update(context, note, index);
	}
	
	public void update(Context context, Note note, int index) {
		EditPrefUtil pref = new EditPrefUtil(context);
		update(context, pref, note, index);
	}

	public boolean isEmpty(Context context){
		List<Note> list = search(context);
		return isEmpty(list);
	}
	
	public boolean isEmpty(List<Note> list){
		for (Note note : list){
			if (!CommonUtil.isNull(note.getGuid())){
				return false;
			}
		}
		return true;
	}

	private void store(EditPrefUtil pref, List<Note> list) {
		StringBuffer sb = new StringBuffer();
		for (Note note : list) {
			sb.append(note.getGuid());
			sb.append(DELM);
			sb.append(note.getTitle());
			sb.append(DELM);
		}
		String data = sb.toString();
		pref.put(Constant.PREF_NOTE_DAO, data);
		pref.update();
	}

	private List<Note> search(Context context, EditPrefUtil pref) {
		String data = pref.get(Constant.PREF_NOTE_DAO);
		List<Note> list = new ArrayList<Note>();
		Note n;

		if (CommonUtil.isNull(data)) {
			for (int i = 0; i < size; i++) {
				n = new Note("", "");
				list.add(n);
			}
			store(pref, list);
			return list;
		}

		List<String> strs = CommonUtil.split(data, DELM);
		if (strs.size() != size * 2) {
			return null;
		}

		for (int i = 0; i < size; i++) {
			n = new Note(strs.get(i * 2), strs.get(i * 2 + 1));
			list.add(n);
		}

		return list;
	}

	public int search(Context context, Note note) {
		List<Note> list = search(context);
		return list.indexOf(note);
	}
	
	private void update(Context context, EditPrefUtil pref, Note note, int index) {
		List<Note> list = search(context, pref);
		list.set(index, note);
		store(pref, list);
	}
}
