package com.yuji.ef.task;

import java.lang.ref.WeakReference;

import com.yuji.ef.SettingActivity;
import com.yuji.ef.common.Constant;
import com.yuji.ef.dao.LockDao;
import com.yuji.ef.exception.EfError;
import com.yuji.ef.exception.EfException;
import com.yuji.ef.exception.RollbackException;
import com.yuji.ef.utility.AsyncTaskIF;
import com.yuji.ef.utility.Debug;
import com.yuji.ef.utility.FolderUtil;
import com.yuji.ef.utility.SdLog;

public class NoteUpdateTask implements AsyncTaskIF {
	public static final Object LOCK_OBJ = new Object();

	private WeakReference<SettingActivity> activityRef;

	private boolean isRoot;
	private boolean isBook;
	private boolean isNote;
	private boolean isDisplayError;
	private int errorCode = -1;

	public NoteUpdateTask(SettingActivity activity, boolean isRoot,
			boolean isBook, boolean isNote, boolean isDisplayError) {
		activityRef = new WeakReference<SettingActivity>(activity);
		this.isRoot = isRoot;
		this.isBook = isBook;
		this.isNote = isNote;
		this.isDisplayError = isDisplayError;
	}

	public void doExecute() throws EfException {
		try {
			SdLog.put("doExecute start");
			// 大量データ
			//FolderUtil test = FolderUtil.getInstance();
			//test.createTestNote();
			// マニュアル用
			//EvernoteUtil.getInstance().createHelpData();
			
			FolderUtil util = FolderUtil.getInstance();
			util.update(isRoot, isBook, isNote);
			SdLog.put("doExecute end");
		} catch (RollbackException e) {
			if (isDisplayError) {
				if (e.getError() == EfError.NETWORK) {
					EfException.msg(com.yuji.ef.R.string.ErrorNetwork);
				} else {
					EfException.msg(com.yuji.ef.R.string.ErrorUpdate);
				}
			}
			Debug.d(this, null, e);

			// #29618
			// LockDao lockDao = (LockDao) LockDao.getInstance();
			// lockDao.unlock(SettingActivity.class, Constant.LOCK_UPDATE_NOTE);

			LockDao lockDao = (LockDao) LockDao.getInstance();
			lockDao.unlock(NoteUpdateTask.LOCK_OBJ, Constant.LOCK_UPDATE_NOTE);

			SdLog.put(e);
			throw e;
		} catch (Exception e) {
			if (isDisplayError) {
				EfException.msg(com.yuji.ef.R.string.ErrorUpdate);
			}
			Debug.d(this, null, e);

			// #29618
			// LockDao lockDao = (LockDao) LockDao.getInstance();
			// lockDao.unlock(SettingActivity.class, Constant.LOCK_UPDATE_NOTE);

			LockDao lockDao = (LockDao) LockDao.getInstance();
			lockDao.unlock(NoteUpdateTask.LOCK_OBJ, Constant.LOCK_UPDATE_NOTE);

			SdLog.put(e);
			throw new EfException(EfError.SYSTEM);
		} catch (Throwable e) {
			if (isDisplayError) {
				EfException.msg(com.yuji.ef.R.string.ErrorUpdate);
			}
			Debug.d(this, null, e);

			// #29618
			// LockDao lockDao = (LockDao) LockDao.getInstance();
			// lockDao.unlock(SettingActivity.class, Constant.LOCK_UPDATE_NOTE);

			LockDao lockDao = (LockDao) LockDao.getInstance();
			lockDao.unlock(NoteUpdateTask.LOCK_OBJ, Constant.LOCK_UPDATE_NOTE);

			SdLog.put(e);
			throw new EfException(EfError.SYSTEM);
		}
	}

	public void cancel() {

	}

	public void done(boolean isCancel) {
		// #29618
		// LockDao lockDao = (LockDao) LockDao.getInstance();
		// lockDao.unlock(SettingActivity.class, Constant.LOCK_UPDATE_NOTE);

		LockDao lockDao = (LockDao) LockDao.getInstance();
		lockDao.unlock(NoteUpdateTask.LOCK_OBJ, Constant.LOCK_UPDATE_NOTE);

		SettingActivity activity = getActivity();
		if (activity != null) {
			activity.done(errorCode);
			activityRef = null;
		}
	}

	private SettingActivity getActivity() {
		if (activityRef == null) {
			return null;
		}
		return activityRef.get();
	}

	@Override
	public int getStatus() {
		// NOT USED
		return 0;
	}
}
