package com.yuji.ef.service;

import java.util.Calendar;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.widget.Toast;

import com.evernote.client.oauth.android.EvernoteSession;
import com.yuji.ef.Initialize;
import com.yuji.ef.R;
import com.yuji.ef.common.Constant;
import com.yuji.ef.dao.LockDao;
import com.yuji.ef.dao.NodeCacheDao;
import com.yuji.ef.dao.NodeDao;
import com.yuji.ef.exception.EfError;
import com.yuji.ef.exception.EfException;
import com.yuji.ef.exception.RollbackException;
import com.yuji.ef.pref.EditPrefUtil;
import com.yuji.ef.task.NoteUpdateTask;
import com.yuji.ef.utility.DateUtil;
import com.yuji.ef.utility.Debug;
import com.yuji.ef.utility.EvernoteUtil;
import com.yuji.ef.utility.NetworkUtil;
import com.yuji.ef.utility.OAuthUtil;
import com.yuji.ef.utility.SdLog;

public class NoteUpdatorService extends Service {
	private static final boolean DEBUG = false;

	public class KitchenTimerBinder extends Binder {
		public NoteUpdatorService getService() {
			return NoteUpdatorService.this;
		}
	}

	public static final String ACTION = "NoteUpdatorService";
	public static final String ACTION_START = "START";
	private EditPrefUtil pref = new EditPrefUtil(this);
	private KitchenTimerBinder binder = new KitchenTimerBinder();
	private String action = null;

	@Override
	public void onCreate() {
		super.onCreate();

		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(), "onCreate()",
					Toast.LENGTH_SHORT);
			toast.show();
		}
	}

	private Runnable task = new Runnable() {
		public void run() {
			try {
				// cancelAlermTime(NoteUpdatorService.this);

				if (action.equals(ACTION_START)) {
					// 初期起動
				} else {
					// タイマー起動
					synchronized (binder) {
						LockDao dao = (LockDao) LockDao.getInstance();
						try {
							if (!NetworkUtil
									.isConnected(NoteUpdatorService.this)) {
								updateDate(NoteUpdatorService.this
										.getString(R.string.serviceUpdateDisableNetworkMsg));
								return;
							}
							OAuthUtil authUtil = OAuthUtil.getInstance();
							EvernoteSession session = authUtil
									.setupSession(NoteUpdatorService.this);
							EvernoteUtil util = EvernoteUtil.getInstance();
							util.setSession(session);
							if (!util.isLoggedIn()) {
								updateDate(NoteUpdatorService.this
										.getString(R.string.serviceUpdateNotLoggedkMsg));
								return;
							}
							
							Initialize.initialize(NoteUpdatorService.this, null);

							boolean b = dao.lock(NoteUpdatorService.this,
									Constant.LOCK_UPDATE_NOTE);
							if (b) {
								execute();
							} else {
								String info = dao.getLockInfo();
								Debug.d(this, info);
								updateDate(NoteUpdatorService.this
										.getString(R.string.serviceUpdateReferenceDataMsg));
							}
						} catch (RollbackException e) {
							if (e.getError() == EfError.NETWORK) {
								updateDate(NoteUpdatorService.this
										.getString(R.string.serviceUpdateDisableNetworkMsg));
							} else {
								updateDate(NoteUpdatorService.this
										.getString(R.string.serviceUpdateUnexpectedErrorkMsg));
							}
						} catch (Exception e) {
							Debug.d(this, null, e);
							SdLog.put(e);
							updateDate(NoteUpdatorService.this
									.getString(R.string.serviceUpdateUnexpectedErrorkMsg));
						} finally {
							// ロック未取得でも解除する(ゴミ掃除)
							dao.unlock(NoteUpdatorService.this,
									Constant.LOCK_UPDATE_NOTE);

							Intent intent = new Intent(Constant.ACTION_UPDATE);
							sendBroadcast(intent);
						}
					}
				}
			} finally {
				setNextTime(NoteUpdatorService.this);
				NoteUpdatorService.this.stopSelf();
			}
		}

		private void execute() throws EfException {
			pref.put(Constant.PREF_UPDATE_DATA, Constant.ON);
			pref.update();

			//Initialize.initialize(NoteUpdatorService.this, null);

			NoteUpdateTask task = new NoteUpdateTask(null, true, true, true,
					false);
			task.doExecute();

			updateDate(null);
		}

	};

	private void updateDate(String msg) {
		Calendar cal = Calendar.getInstance();
		String date = DateUtil.toDateString(this, cal.getTimeInMillis());

		if (msg != null) {
			date = date + " (" + msg + ")";
		}

		pref.put(Constant.PREF_UPDATE_DATETIME, date);
		pref.update();
	}

	@Override
	public void onStart(Intent intent, int startId) {
		super.onStart(intent, startId);

		action = intent.getAction();
		action = (action == null) ? "" : action;

		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(), "onStart() "
					+ action + " " + startId, Toast.LENGTH_SHORT);
			toast.show();
		}

		Thread thread = new Thread(null, task, "AlarmService_Service");
		thread.start();
	}

	@Override
	public void onDestroy() {
		super.onDestroy();

		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(),
					"onDestroy()", Toast.LENGTH_SHORT);
			toast.show();
		}
	}

	@Override
	public IBinder onBind(Intent intent) {
		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(), "onBind()",
					Toast.LENGTH_SHORT);
			toast.show();
		}

		return binder;
	}

	@Override
	public void onRebind(Intent intent) {
		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(), "onRebind()",
					Toast.LENGTH_SHORT);
			toast.show();
		}
	}

	@Override
	public boolean onUnbind(Intent intent) {
		if (DEBUG) {
			Toast toast = Toast.makeText(getApplicationContext(), "onUnbind()",
					Toast.LENGTH_SHORT);
			toast.show();
		}
		return true;
	}

	public static void setNextTime(Context context) {
		EditPrefUtil pref = new EditPrefUtil(context);

		long updateTime = pref.getLong(Constant.PREF_UPDATE_TIME);
		if (updateTime <= 0) {
			return;
		}

		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.HOUR, (int) updateTime);
		//cal.add(Calendar.SECOND, 60); // TODO

		long t = cal.getTimeInMillis();
		PendingIntent alarmSender = PendingIntent.getService(context, 0,
				new Intent(context, NoteUpdatorService.class), 0);
		AlarmManager am = (AlarmManager) context
				.getSystemService(Context.ALARM_SERVICE);
		am.set(AlarmManager.RTC, t, alarmSender);

		pref.put(Constant.PREF_NEXT_TIME, t);
		pref.update();
	}

	private static void cancelAlermTime(Context context) {
		Calendar cal = Calendar.getInstance();

		long t = cal.getTimeInMillis();
		PendingIntent alarmSender = PendingIntent.getService(context, 0,
				new Intent(context, NoteUpdatorService.class), 0);
		AlarmManager am = (AlarmManager) context
				.getSystemService(Context.ALARM_SERVICE);
		am.cancel(alarmSender);
	}

	public static void stopService(Context context) {
		PendingIntent alarmSender = PendingIntent.getService(context, 0,
				new Intent(context, NoteUpdatorService.class),
				PendingIntent.FLAG_CANCEL_CURRENT);
	}

	public static boolean isSetAlarmSender(Context context) {
		PendingIntent alarmSender = PendingIntent.getService(context, 0,
				new Intent(context, NoteUpdatorService.class),
				PendingIntent.FLAG_NO_CREATE);
		return alarmSender != null;
	}

	public static void init(Context context) {
		EditPrefUtil pref = new EditPrefUtil(context);

		boolean isSet = NoteUpdatorService.isSetAlarmSender(context);
		int updateTime = pref.getInt(Constant.PREF_UPDATE_TIME);

		// サービス起動中でなく、ロックが残っている場合、削除(DB排他で、ロックされないこと)
		// サービスのロック削除
		long t = pref.getLong(Constant.PREF_NEXT_TIME);
		Calendar cal = Calendar.getInstance();
		long now = cal.getTimeInMillis();
		if (t < now) {
			isSet = false;

			// サービス起動中の場合は、DBロックがかかり
			// 下記の処理でLockDaoがLOCK_UPDATE_NOTEを削除させないようにするため
			// ダミーでisEmpty()を読んでいる
			NodeDao nodeDao = (NodeDao) NodeCacheDao.getInstance();
			nodeDao.isEmpty();
			
			// サービスが起動していない & ロックが残ってしまったので、強制的に削除
			LockDao lockDao = (LockDao) LockDao.getInstance();
			lockDao.unlock(NoteUpdatorService.class, Constant.LOCK_UPDATE_NOTE);
			// サービスでのロック解除のため、下記は削除しない
			// lockDao.unlock(NoteUpdateTask.LOCK_OBJ, Constant.LOCK_UPDATE_NOTE);
			//lockDao.unlock(SettingActivity.class, Constant.LOCK_UPDATE_NOTE);
			lockDao = null;
		}

		if (updateTime > 0) {
			if (!isSet) {
				// 再起動時
				setNextTime(context);
			}
		} else {
			if (isSet) {
				// データ削除時
				// isSetはクリアされないが、問題ないので毎回よぶ
				stopService(context);
			}
		}
	}
}