package com.yuji.ef;

import java.util.ArrayList;
import java.util.List;

import com.yuji.ef.exception.EfException;

import android.content.Context;
import android.graphics.PorterDuff.Mode;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnLongClickListener;
import android.view.animation.Animation;
import android.view.animation.Animation.AnimationListener;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;

public class IconFrameLayout extends FrameLayout implements OnLongClickListener {
	private EverFolderActivity activity = null;

	private LabelIconView target = null;
	private LabelIconView destTarget = null;
	private LabelIconView selectedTarget = null;
	private LabelIconView cutTarget = null;
	private List<LabelIconView> labelIconViewList = new ArrayList<LabelIconView>();

	private Animation anime;
	private int currentX;
	private int currentY;
	private int offsetX;
	private int offsetY;
	private boolean longClickFlg = false;
	private IconScrollView scrollView;
	private Context context = this.getContext();
	private boolean elabledTouchEvent = true;

	public IconFrameLayout(Context context) {
		super(context);
	}

	public IconFrameLayout(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public IconFrameLayout(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
	}

	public void setActivity(EverFolderActivity activity) {
		this.activity = activity;
	}

	@Override
	protected void onLayout(boolean changed, int left, int top, int right,
			int bottom) {
		super.onLayout(changed, left, top, right, bottom);

		int size = this.getChildCount();
		for (int i = 0; i < size; i++) {
			LabelIconView vv = (LabelIconView) this.getChildAt(i);
			int x2 = vv.getInitX();
			int y2 = vv.getInitY();
			// vv.init(x2, y2);
			vv.layout(x2, y2, x2 + vv.getWidth(), y2 + vv.getHeight());
		}
	}

	public LabelIconView getSelectedTarget() {
		return selectedTarget;
	}

	public void addView(LabelIconView child) {
		addView(child, true);
	}

	public void addView(LabelIconView child, boolean isAddView) {
		if (isAddView) {
			super.addView(child);
		}
		labelIconViewList.add(child);
	}

	public void removeAllViews() {
		super.removeAllViews();
		labelIconViewList.clear();
	}

	public void moveTop(LabelIconView child) {
		this.removeView(child);
		this.addView(child);
	}

	private LabelIconView getView(int x, int y, LabelIconView v,
			List<LabelIconView> list, boolean flag) {
		Rect rect = new Rect();

		if (v != null) {
			if (flag) {
				v.getHitRect(rect);
				if (rect.contains(x, y)) {
					return v;
				}
			}
		}
		for (LabelIconView view : list) {
			if (view != v) {
				view.getHitRect(rect);
				if (rect.contains(x, y)) {
					return view;
				}
			}
		}
		return null;
	}

	public void setScrollView(final IconScrollView scrollView) {
		this.scrollView = scrollView;
		this.setOnLongClickListener(this);
		// this.setLongClickable(true);

		anime = AnimationUtils.loadAnimation(context, R.anim.sample);
		anime.setAnimationListener(new AnimationListener() {
			public void onAnimationStart(Animation animation) {
			}

			public void onAnimationRepeat(Animation animation) {
			}

			public void onAnimationEnd(Animation animation) {
				// if (isBt2Click) {
				// bt2.performClick();
				// isBt2Click = false;
				// }
				clearTarget();
				setTarget(null);
				destTarget = null;

				scrollView.setScrollable(true);
				scrollView.requestDisallowInterceptTouchEvent(false);
				scrollView.invalidate();
			}
		});
	}

	public void refresh() {
		if (selectedTarget != null) {
			boolean flag = false;
			long id = selectedTarget.getNodeId();
			for (LabelIconView view : labelIconViewList) {
				if (view.getNodeId() == id) {
					setSelectedTarget(view);
					setTarget(view);
					setSelected(selectedTarget);
					flag = true;
					break;
				}
			}
			if (!flag) {
				// 表示されなかった(CLOSEなど)
				setSelectedTarget(null);
				setTarget(null);
			}
		}
		if (cutTarget != null) {
			boolean flag = false;
			long id = cutTarget.getNodeId();
			for (LabelIconView view : labelIconViewList) {
				if (view.getNodeId() == id) {
					cutTarget = view;
					if (selectedTarget != cutTarget) {
						clearColorFilter(cutTarget);
					}
					flag = true;
					break;
				}
			}
			if (!flag) {
				// 表示されなかった(CLOSEなど)
				cutTarget = null;
			}
		}
	}

	public void clearTarget() {
		if (selectedTarget != null) {
			clearColorFilter(selectedTarget);
			setSelectedTarget(null);
		}
		setTarget(null);
	}

	public LabelIconView getCutTarget() {
		return cutTarget;
	}

	public void setCutTarget(LabelIconView cutTarget) {
		setCutTarget(cutTarget, true);
	}

	public void setCutTarget(LabelIconView cutTarget, boolean isUnselected) {
		if (this.cutTarget != null){
			setAlpha(this.cutTarget);
		}
		this.cutTarget = cutTarget;
		if (cutTarget != null){
			if (cutTarget instanceof StatusIconView){
				return;
			}
		}
		if (isUnselected) {
			setSelectedTarget(null);
			setTarget(null);
		}
	}

	public void setSelectedTarget(LabelIconView selectedTarget){
		if (selectedTarget != null){
			if (selectedTarget instanceof StatusIconView){
				return;
			}
		}
		this.selectedTarget = selectedTarget;
	}
	
	public void setTarget(LabelIconView target){
		if (target != null){
			if (target instanceof StatusIconView){
				return;
			}
		}
		this.target = target;
	}
	
	private void setSelected(LabelIconView t) {
		t.setAlpha(255);
		t.setColorFilter(0x88ff0000, Mode.LIGHTEN);
	}

	private void setAlpha(LabelIconView v) {
		v.setAlpha(255);
	}

	private void setGrayAlpha(LabelIconView v) {
		v.setAlpha(128);
	}

	private void clearColorFilter(LabelIconView v) {
		v.clearColorFilter();
		if (v == cutTarget) {
			setGrayAlpha(v);
		}
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		try {
			if (!isElabledTouchEvent()) {
				return super.onTouchEvent(event);
			}

			int x = (int) event.getRawX();
			int y = (int) event.getRawY();

			int dx = scrollView.getLeft();
			int dy = scrollView.getTop();

			x -= dx;
			y -= dy;

			int sx = x + scrollView.getScrollX();
			int sy = y + scrollView.getScrollY();
			LabelIconView v = getView(sx, sy, target, labelIconViewList, true);
			LabelIconView obj = (LabelIconView) v;

			if (target == null) {
				if (event.getAction() == MotionEvent.ACTION_DOWN) {
					setTarget(obj);
				}
			}
			if (target == null) {
				return super.onTouchEvent(event);
			}

			// コメントにすると何が起きるか？
			// scrollView.requestDisallowInterceptTouchEvent(true);

			if (event.getAction() == MotionEvent.ACTION_MOVE) {
				if (!longClickFlg) {
					return super.onTouchEvent(event);
				}
				if (target == null || target instanceof StatusIconView) {
					return super.onTouchEvent(event);
				}
				obj = target;

				int sh = scrollView.getHeight();
				int lh = this.getHeight();
				int maxY = lh - sh;
				int py = scrollView.getScrollY();
				int sdy = 10;
				int N = 100;
				if (y < N) {
					if (py > 0) {
						if (py < sdy) {
							sdy = py;
						}
						scrollView.smoothScrollTo(0, py - sdy);
						currentY -= sdy;
					}
				} else if (sh - y < N) {
					if (py < maxY) {
						if (maxY - py < sdy) {
							sdy = maxY - py;
						}
						scrollView.smoothScrollTo(0, py + sdy);
						currentY += sdy;
					}
				}

				int diffX = offsetX - x;
				int diffY = offsetY - y;

				currentX -= diffX;
				currentY -= diffY;
				obj.layout(currentX, currentY, currentX + obj.getWidth(),
						currentY + obj.getHeight());

				offsetX = x;
				offsetY = y;

				v = getView(sx, sy, target, labelIconViewList, false);
				if (destTarget == null) {
					if (v != null) {
						destTarget = v;
						setGrayAlpha(destTarget);
					}
				} else {
					if (v != destTarget) {
						setAlpha(destTarget);
						destTarget = v;
						if (destTarget != null) {
							setGrayAlpha(destTarget);
						}
					}
				}
			} else if (event.getAction() == MotionEvent.ACTION_DOWN) {
				if (obj != null) {
					if (obj != target) {
						clearColorFilter(target);
						setTarget(obj);
					}
					if (target.getSelectedView(sx - target.getLeft(), sy
							- target.getTop()) instanceof StatusIconView) {
						long id = target.getNodeId();
						setTarget(null);

						activity.execute(id);
						return super.onTouchEvent(event);
					}

					if (selectedTarget != null && selectedTarget == target) {
						long id = selectedTarget.getNodeId();
						boolean isDirNode = target.getStatusImageView() != null;
						
						clearColorFilter(target);
						setTarget(null);
						setSelectedTarget(null);
						activity.targetSelectedChanged(true);

						if (isDirNode){
							activity.execute(id);							
						}
						else {
							activity.executeView(id);
						}
						
						return super.onTouchEvent(event);
					}

					// ここに移動
					scrollView.requestDisallowInterceptTouchEvent(true);

					offsetX = x;
					offsetY = y;
					currentX = obj.getLeft();
					currentY = obj.getTop();

					setSelected(target);
					setSelectedTarget(target);
					activity.targetSelectedChanged(true);
					
					// コメントにしたが、デグレードするかも
					// scrollView.setScrollable(false);
				} else {
					clearColorFilter(target);
					setTarget(null);
					setSelectedTarget(null);
					activity.targetSelectedChanged(false);
				}
			} else if (event.getAction() == MotionEvent.ACTION_UP) {
				if (!longClickFlg) {
					return super.onTouchEvent(event);
				}
				if (target == null || target instanceof StatusIconView) {
					return super.onTouchEvent(event);
				}
				obj = target;

				if (destTarget == null || destTarget instanceof StatusIconView) {
					obj.setAnimation(anime);
					obj.startAnimation(anime);

					int srcX = target.getInitX();
					int srcY = target.getInitY();
					target.layout(srcX, srcY, srcX + target.getWidth(), srcY
							+ target.getHeight());
					setAlpha(target);
				} else {
					long src = target.getNodeId();
					long dst = destTarget.getNodeId();
					
					setCutTarget(null, false);
					activity.execute(src, dst);

					setTarget(null);
					destTarget = null;

					// T29171
					clearTarget();

					scrollView.setScrollable(true);
					scrollView.requestDisallowInterceptTouchEvent(false);
					scrollView.invalidate();
				}

				longClickFlg = false;
			}

			return super.onTouchEvent(event);
		} catch (Exception e) {
			EfException.msg(R.string.ErrorSystem, e);
			return false;
		}
	}

	@Override
	public boolean onLongClick(View view) {
		if (!isElabledTouchEvent()) {
			return true;
		}
		if (target == null) {
			return false;
		}
		if (target instanceof StatusIconView) {
			return false;
		}

		LabelIconView v = (LabelIconView) target;
		setGrayAlpha(v);
		v.clearColorFilter();

		moveTop(target);

		longClickFlg = true;
		return true;
	}

	public boolean isElabledTouchEvent() {
		return elabledTouchEvent;
	}

	public void setElabledTouchEvent(boolean elabledTouchEvent) {
		this.elabledTouchEvent = elabledTouchEvent;
	}
}
