/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.edam.business;

import com.evernote.edam.business.Business;
import com.evernote.edam.business.BusinessAccountManager;
import com.evernote.edam.business.BusinessAccountingDetail;
import com.evernote.edam.business.BusinessImage;
import com.evernote.edam.business.BusinessUser;
import com.evernote.edam.business.BusinessUserFilter;
import com.evernote.edam.business.BusinessUserRole;
import com.evernote.edam.business.BusinessUserStatus;
import com.evernote.edam.business.CreateBusinessResult;
import com.evernote.edam.business.CreateBusinessUserResult;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.User;
import java.util.List;
import org.apache.thrift.TException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BusinessServiceIface {
    public void activateBusinessUserWithPassword(int var1, String var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public void activateBusinessUserWithNameAndPassword(int var1, String var2, String var3) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public CreateBusinessResult createBusiness(User var1, String var2, String var3, Business var4) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public List<CreateBusinessUserResult> addBusinessUsers(int var1, List<User> var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public BusinessUser findActiveBusinessUserByUserId(int var1) throws EDAMUserException, EDAMSystemException, TException;

    public BusinessUser findBusinessUserByUserId(int var1) throws EDAMUserException, EDAMSystemException, TException;

    public BusinessUser getBusinessUserByUserId(int var1) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public BusinessUser findBusinessUserByEmail(String var1) throws EDAMUserException, EDAMSystemException, TException;

    public BusinessUser getBusinessUserByEmail(String var1) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public void updateBusiness(Business var1) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public BusinessAccountManager createAccountManager(String var1, String var2, String var3) throws EDAMUserException, EDAMSystemException, TException;

    public List<BusinessAccountManager> findAccountManagersByEmail(String var1) throws EDAMUserException, EDAMSystemException, TException;

    public void updateAccountManager(BusinessAccountManager var1) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public List<BusinessAccountManager> listAccountManagers() throws EDAMSystemException, TException;

    public void setAccountManager(int var1, int var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Business activateBusiness(int var1) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Business deactivateBusiness(int var1) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Business leaseBusinessWithOutstandingOrder(long var1) throws EDAMSystemException, EDAMNotFoundException, TException;

    public void updateBusinessLeaseOrder(int var1, long var2) throws EDAMSystemException, EDAMNotFoundException, TException;

    public void createBusinessAccountingDetails(List<BusinessAccountingDetail> var1) throws EDAMSystemException, TException;

    public List<BusinessAccountingDetail> findBusinessAccountingDetailsByOrder(String var1) throws EDAMSystemException, TException;

    public List<BusinessAccountingDetail> findBusinessAccountingDetails(int var1) throws EDAMSystemException, TException;

    public void startBusinessPremiumService(int var1, String var2, String var3) throws EDAMSystemException, EDAMNotFoundException, TException;

    public void recurringBusinessPaymentRequested(int var1) throws EDAMSystemException, EDAMNotFoundException, TException;

    public void recurringBusinessPaymentMade(int var1, long var2, String var4) throws EDAMSystemException, EDAMNotFoundException, TException;

    public void recurringBusinessPaymentFailed(int var1, String var2) throws EDAMSystemException, EDAMNotFoundException, TException;

    public void onDemandPaymentMade(int var1, String var2, long var3) throws EDAMSystemException, EDAMNotFoundException, TException;

    public void createOrUpdateBusinessImage(BusinessImage var1) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public BusinessImage findBusinessImage(int var1) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public void setBusinessUserStatus(int var1, int var2, BusinessUserStatus var3) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public void setBusinessUserRole(int var1, int var2, BusinessUserRole var3) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Business getBusinessById(int var1) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public Business getBusinessByUri(String var1) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;

    public List<Business> listBusinesses() throws EDAMSystemException, TException;

    public List<BusinessUser> listActiveBusinessUsers(int var1) throws EDAMSystemException, TException;

    public boolean isActiveUserLimitReached(int var1) throws EDAMSystemException, EDAMNotFoundException, TException;

    public List<BusinessUser> listBusinessUsers(int var1, BusinessUserFilter var2) throws EDAMSystemException, TException;

    public int getBusinessUserCount(int var1, BusinessUserFilter var2) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException;
}

