package com.yuji.ec.utility;

import java.util.Comparator;

import com.yuji.ec.common.Constant;
import com.yuji.ec.db.Note;

public class NoteComparator implements Comparator<Note> {
	private int noteOrder;
	private int orderBy;
	
	public NoteComparator(int noteOrder, int orderBy){
		this.noteOrder = noteOrder;
		this.orderBy = orderBy;
	}
	
	public int compare(Note arg0, Note arg1) {
		int comp = 0;
		long lcomp = 0;

		switch (noteOrder){
		case Constant.NOTE_ORDER_CREATE:
			lcomp = arg0.getCreated() - arg1.getCreated();
			break;
		case Constant.NOTE_ORDER_UPDATE:
			lcomp = arg0.getUpdated() - arg1.getUpdated();
			break;
		case Constant.NOTE_ORDER_TEXT:
			lcomp = (long)arg0.getText().compareTo(arg1.getText());
			break;
		}
		
		if (lcomp > 0){
			comp = 1;
		}
		else if (lcomp < 0){
			comp = -1;
		}
		if (orderBy == Constant.NOTE_ORDER_BY_DES){
			comp = -comp;
		}
		
		return comp;
	}
}
