/*
 Copyright (C) 2010 Kuri-Applications

 Unknown.h - declarations and implementations of CUnknownImplT
 */

#pragma once

template <class T>
class CUnknownImplT : public T
{
public:
	CUnknownImplT() { m_uRef = 1; }
	virtual ~CUnknownImplT() { }

	STDMETHOD(QueryInterface)(REFIID riid, void FAR* FAR* ppv) { return E_NOINTERFACE; }
	STDMETHOD_(ULONG, AddRef)() { return ++m_uRef; }
	STDMETHOD_(ULONG, Release)()
	{
		if (!--m_uRef)
		{
			delete this;
			return 0;
		}
		return m_uRef;
	}
protected:
	ULONG m_uRef;
};

typedef CUnknownImplT<IUnknown> CUnknownImpl;
