/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.render;

import jp.sourceforge.dvibrowser.dvicore.DviException;
import jp.sourceforge.dvibrowser.dvicore.DviFontSpec;
import jp.sourceforge.dvibrowser.dvicore.api.DviExecutorContext;
import jp.sourceforge.dvibrowser.dvicore.api.DviExecutorHandler;
import jp.sourceforge.dvibrowser.dvicore.cmd.DviBop;
import jp.sourceforge.dvibrowser.dvicore.cmd.DviPostPost;
import jp.sourceforge.dvibrowser.dvicore.cmd.DviPostamble;
import jp.sourceforge.dvibrowser.dvicore.cmd.DviPreamble;

public class EmptyDviExecutorHandler
implements DviExecutorHandler
{
  public void begin(DviExecutorContext ctx) throws DviException {}
  public void end() throws DviException {}

  public void doSet(int code) throws DviException {}
  public void doSetRule(int w, int h) throws DviException {}
  public void doPut(int code) throws DviException {}
  public void doPutRule(int w, int h) throws DviException {}
  public void doNop() throws DviException {}

  public void doSelectFont(int fn) throws DviException {}
  public void doDefineFont(int fn, DviFontSpec fs) throws DviException {}

  public void doPush() throws DviException {}
  public void doPop() throws DviException {}

  public void doPre(DviPreamble preamble) throws DviException {}
  public void doBop(DviBop bop) throws DviException {}
  public void doEop() throws DviException {}
  public void doPost(DviPostamble postamble) throws DviException {}
  public void doPostPost(DviPostPost postPost) throws DviException {}

  public void doRight(int by) throws DviException {}
  public void doW(int by) throws DviException {}
  public void doW0() throws DviException {}
  public void doX(int by) throws DviException {}
  public void doX0() throws DviException {}

  public void doDown(int by) throws DviException {}
  public void doY(int by) throws DviException {}
  public void doY0() throws DviException {}
  public void doZ(int by) throws DviException {}
  public void doZ0() throws DviException {}

  public void doSpecial(byte [] xxx) throws DviException {}
}
